package eu.dnetlib.data.mapreduce.hbase.dedup.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import com.google.common.collect.ComparisonChain;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

/**
 * Created by claudio on 13/03/2017.
 */
public class DNGFKey implements Writable, WritableComparable<DNGFKey> {

	public final static int MERGES_REL = 0;
	public final static int OTHER_REL = 1;

	private IntWritable keyType;

	private Text id;

	public DNGFKey() {}

    public DNGFKey(final int keyType, final String id) {
        this.id = new Text(id);
        this.keyType = new IntWritable(keyType);
    }

	public static DNGFKey create(final int keyType, final String id) {
		return new DNGFKey(keyType, id);
	}

	public static DNGFKey mergesRel(final String id) {
		return new DNGFKey(MERGES_REL, id);
	}

	public static DNGFKey otherRel(final String id) {
		return new DNGFKey(OTHER_REL, id);
	}

	public Text getId() {
		return id;
	}

    public void setId(final Text id) {
        this.id = id;
    }

	public IntWritable getKeyType() {
		return keyType;
	}

    public void setKeyType(final IntWritable keyType) {
        this.keyType = keyType;
    }

	@Override
	public int compareTo(final DNGFKey o) {
        int compareValue = this.id.toString().compareTo(o.getId().toString());
        if (compareValue == 0) {
            compareValue = this.keyType.compareTo(o.getKeyType());
        }
        return compareValue;    // sort ascending
    }

	@Override
	public void write(final DataOutput out) throws IOException {
		keyType.write(out);
		id.write(out);
	}

	@Override
	public void readFields(final DataInput in) throws IOException {
		keyType = new IntWritable();
		keyType.readFields(in);
		id = new Text();
		id.readFields(in);
	}

	@Override
	public String toString() {
		return (new StringBuilder())
				.append('{')
				.append(getKeyType().get())
				.append(',')
				.append(getId())
				.append('}')
				.toString();
	}
}
