package eu.dnetlib.data.mapreduce.hbase.oai.utils;

import java.util.Map.Entry;

import com.google.common.collect.Multimap;

/**
 * Instances of this class represent fields to be explicitely managed by the OAI Publisher, for example for indexing purposes.
 * 
 * @author alessia
 * 
 */
public class PublisherField {

	/**
	 * Name of the field.
	 */
	private String fieldName;
	/**
	 * True if the value of the field is a list (i.e. repeatable values). False otherwise.
	 **/
	private boolean repeatable;
	/**
	 * Information about where to take values for this field.
	 * <p>
	 * Keys are metadata format: name-layout-interpretation; values are xpaths.
	 * </p>
	 */
	private Multimap<String, String> sources;

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(final String fieldName) {
		this.fieldName = fieldName;
	}

	public boolean isRepeatable() {
		return repeatable;
	}

	public void setRepeatable(final boolean repeatable) {
		this.repeatable = repeatable;
	}

	public Multimap<String, String> getSources() {
		return sources;
	}

	public void setSources(final Multimap<String, String> sources) {
		this.sources = sources;
	}

	public PublisherField() {
		super();
		// TODO Auto-generated constructor stub
	}

	public PublisherField(final String fieldName, final boolean repeatable, final Multimap<String, String> sources) {
		super();
		this.fieldName = fieldName;
		this.repeatable = repeatable;
		this.sources = sources;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("fieldname: " + getFieldName() + "\n");
		sb.append("repeatible: " + isRepeatable() + "\n");
		sb.append("sources { ");
		for (Entry<String, String> e : getSources().entries()) {
			sb.append("\n\t" + e.getKey() + ":" + e.getValue() + "\n");
		}
		sb.append("}");
		return sb.toString();
		// Gson gson = new GsonBuilder().setPrettyPrinting().create();
		// return gson.toJson(this);
	}
}
