package eu.dnetlib.data.mapreduce.hbase.wds;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.WdsPublicationProtos;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;

import java.io.IOException;
import java.util.List;

import static eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO.getMetadata;
import static eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO.rel;

public class ExtendProjectInfoMapper extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {

    private ImmutableBytesWritable outKey = new ImmutableBytesWritable();
    private ImmutableBytesWritable outValue = new ImmutableBytesWritable();

    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {

    }

    @Override
    protected void map(final ImmutableBytesWritable rowkey, final Result value, final Context context) throws InvalidProtocolBufferException {



        final TypeProtos.Type type = DNGFRowKeyDecoder.decode(rowkey.copyBytes()).getType();
        if (type == TypeProtos.Type.publication) {
            final DNGFProtos.DNGF entity = getMetadata(value, type);
            List<FieldTypeProtos.ProjectRelation> projects = entity.getEntity().getPublication().getMetadata().getExtension(WdsPublicationProtos.WdsPublication.projects);
            if (projects!= null && projects.size() > 0){
                context.getCounter("Projet", "found").increment(1);
                rel(value, "isMergedIn", "merges", "isSimilarTo").values().forEach(
                        r -> projects.forEach(p -> emit(r.getRel().getTarget(),context, p.toByteArray(), type)));
            }
        }
        if (type == TypeProtos.Type.dataset) {
            final DNGFProtos.DNGF entity = getMetadata(value, type);
            if (entity!= null)
                emit(entity.getEntity().getId(), context, entity.getEntity().toByteArray(),type);
        }
    }

    private void emit(final String id, final Context context, final byte[] data, TypeProtos.Type type) {
        try {
            if (type.equals(TypeProtos.Type.publication))
                context.getCounter("Project", "emmitted").increment(1);
            else
                context.getCounter("Dataset", "emmitted").increment(1);
            outKey.set(Bytes.toBytes(id));
            outValue.set(data);
         context.write(outKey, outValue);
        } catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}
