/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dli;

import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.dli.kv.DliKey;
import eu.dnetlib.data.proto.dli.ScholixObjectProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PrepareScholixDataReducer2
extends Reducer<DliKey, ImmutableBytesWritable, Text, Text> {
    private static final Log log = LogFactory.getLog(PrepareScholixDataReducer2.class);
    private Text outKey;
    private Text outValue;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.outKey = new Text("");
        this.outValue = new Text();
    }

    protected void reduce(DliKey key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        ArrayList scholixes = Lists.newArrayList();
        values.forEach(i -> scholixes.add(this.parse(key, (ImmutableBytesWritable)i).build()));
        System.out.println("reducing key = " + key);
        if (!scholixes.isEmpty()) {
            ScholixObjectProtos.Scholix source = this.getSource(context, scholixes);
            if (source == null) {
                context.getCounter("scholix", "missing source").increment(1L);
                System.out.println(String.format("missing source in group of %s: %s", scholixes.size(), key.getId()));
                System.out.println(scholixes);
                return;
            }
            scholixes.forEach(t -> {
                if (!t.hasSource()) {
                    ScholixObjectProtos.Scholix.Builder rel = ScholixObjectProtos.Scholix.newBuilder((ScholixObjectProtos.Scholix)t);
                    if (rel.hasTarget()) {
                        rel.setSource(source.getSource());
                        this.emit(context, JsonFormat.printToString((Message)rel.build()));
                    } else {
                        context.getCounter("scholix", "missing target").increment(1L);
                    }
                }
            });
        }
    }

    private ScholixObjectProtos.Scholix getSource(Reducer.Context context, List<ScholixObjectProtos.Scholix> scholixes) {
        for (int i = 0; i < scholixes.size(); ++i) {
            ScholixObjectProtos.Scholix s = scholixes.get(i);
            if (!s.hasSource()) continue;
            context.getCounter("scholix", "first source in position " + i).increment(1L);
            context.getCounter("scholix", "group size " + scholixes.size()).increment(1L);
            return s;
        }
        return null;
    }

    private ScholixObjectProtos.Scholix.Builder parse(DliKey key, ImmutableBytesWritable value) {
        try {
            return ScholixObjectProtos.Scholix.newBuilder((ScholixObjectProtos.Scholix)ScholixObjectProtos.Scholix.parseFrom((byte[])value.copyBytes()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(String.format("cannot parse Scholix, keytype '%s', id '%s'", key.getKeyType(), key.getId()));
        }
    }

    private void emit(Reducer.Context context, String data) {
        this.outValue.set(data.getBytes());
        try {
            context.write((Object)this.outKey, (Object)this.outValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

