/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.IndexConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import eu.dnetlib.miscutils.functional.xml.XMLIndenter;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;

public class PrepareFeedMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private EntityConfigTable entityConfigTable;
    private Ontologies ontologies = null;
    private Text outKey;
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        String json = context.getConfiguration().get("index.entity.links");
        System.out.println("index.entity.links:\n" + json);
        this.entityConfigTable = IndexConfig.load(json).getConfigMap();
        String contextMap = context.getConfiguration().get("contextmap");
        System.out.println("contextmap:\n" + XMLIndenter.indent((String)contextMap));
        this.ontologies = OntologyLoader.loadOntologies((String)context.getConfiguration().get("ontologies"));
        this.outKey = new Text();
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        DNGFRowKeyDecoder keyDecoder = DNGFRowKeyDecoder.decode((byte[])keyIn.copyBytes());
        TypeProtos.Type type = keyDecoder.getType();
        DNGFProtos.DNGF oaf = this.mergeUpdates(value, context, type, keyDecoder);
        if (this.isValid(oaf)) {
            if (!this.deletedByInference(oaf) || this.entityConfigTable.includeDuplicates(type)) {
                this.emit(new String(keyIn.copyBytes()), context, oaf);
                this.incrementCounter(context, KindProtos.Kind.entity.toString(), type.toString(), 1);
                for (LinkDescriptor ld : this.entityConfigTable.getDescriptors(type)) {
                    NavigableMap columnMap = value.getFamilyMap(Bytes.toBytes((String)ld.getRelDescriptor().getCode()));
                    if (!this.hasData(columnMap)) continue;
                    this.emitRelationship(oaf.getEntity(), context, columnMap, ld);
                    this.incrementCounter(context, type.toString(), ld.getRelDescriptor().getCode(), columnMap.size());
                }
            } else {
                this.incrementCounter(context, "deleted by inference", type.toString(), 1);
            }
        } else {
            this.incrementCounter(context, "missing body (map)", type.toString(), 1);
        }
    }

    private DNGFProtos.DNGF mergeUpdates(Result value, Mapper.Context context, TypeProtos.Type type, DNGFRowKeyDecoder keyDecoder) throws InvalidProtocolBufferException {
        try {
            return UpdateMerger.mergeBodyUpdates(context, value.getFamilyMap(HBaseTableDAO.cfMetadataByte()), type);
        }
        catch (InvalidProtocolBufferException e) {
            System.err.println(String.format("Unable to parse proto (Type: %s) in row: %s", type.toString(), keyDecoder.getKey()));
            throw e;
        }
    }

    private void emitRelationship(DNGFProtos.DNGFEntity cachedTarget, Mapper.Context context, Map<byte[], byte[]> columnMap, LinkDescriptor ld) throws IOException, InterruptedException {
        DNGFProtos.DNGF.Builder oafBuilder = DNGFProtos.DNGF.newBuilder().setKind(KindProtos.Kind.relation);
        for (Map.Entry<byte[], byte[]> e : columnMap.entrySet()) {
            DNGFProtos.DNGF oaf = this.decodeProto(context, e.getValue());
            if (!this.isValid(oaf)) {
                this.incrementCounter(context, "invalid oaf rel", ld.getRelDescriptor().getCode(), 1);
                continue;
            }
            if (!this.deletedByInference(oaf)) {
                DNGFProtos.DNGFRel.Builder relBuilder = DNGFProtos.DNGFRel.newBuilder((DNGFProtos.DNGFRel)oaf.getRel());
                if (ld.isSymmetric()) {
                    RelDescriptor rd = ld.getRelDescriptor();
                    relBuilder.setCachedTarget(cachedTarget).setRelType(rd.asQualifier());
                }
                if (ld.getRelDescriptor().getCode().contains("dedup") && this.isDedupSelf((DNGFProtos.DNGFRelOrBuilder)relBuilder)) {
                    this.incrementCounter(context, "avoid to emit dedup self", ld.getRelDescriptor().getCode(), 1);
                    continue;
                }
                DNGFProtos.DNGFRel oafRel = relBuilder.setChild(ld.isChild()).build();
                this.emit(ld.isSymmetric() ? oafRel.getTarget() : oafRel.getSource(), context, this.merge(oafBuilder, oaf).setRel(oafRel).build());
                continue;
            }
            this.incrementCounter(context, "deleted by inference", ld.getRelDescriptor().getCode(), 1);
        }
    }

    private String patchTargetId(TypeProtos.Type target, String id) {
        return id.replaceFirst("^.*\\|", target.getNumber() + "|");
    }

    private DNGFProtos.DNGF.Builder merge(DNGFProtos.DNGF.Builder builder, DNGFProtos.DNGF prototype) {
        return builder.setDataInfo(prototype.getDataInfo()).setLastupdatetimestamp(prototype.getLastupdatetimestamp());
    }

    private boolean isDedupSelf(DNGFProtos.DNGFRelOrBuilder rel) {
        return rel.getSource().contains(rel.getTarget());
    }

    private boolean hasData(Map<byte[], byte[]> columnMap) {
        return columnMap != null && !columnMap.isEmpty();
    }

    private boolean isValid(DNGFProtos.DNGF oaf) {
        return oaf != null && oaf.isInitialized();
    }

    private boolean deletedByInference(DNGFProtos.DNGF oaf) {
        return oaf.getDataInfo().getDeletedbyinference();
    }

    private DNGFProtos.DNGF decodeProto(Mapper.Context context, byte[] body) {
        try {
            return DNGFProtos.DNGF.parseFrom((byte[])body);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace(System.err);
            context.getCounter("decodeProto", ((Object)((Object)e)).getClass().getName()).increment(1L);
            return null;
        }
    }

    private void emit(String key, Mapper.Context context, DNGFProtos.DNGF oaf) throws IOException, InterruptedException {
        this.outKey.set(key);
        this.ibw.set(oaf.toByteArray());
        context.write((Object)this.outKey, (Object)this.ibw);
    }

    private void incrementCounter(Mapper.Context context, String k, String t, int n) {
        this.getCounter(context, k, t).increment((long)n);
    }

    private Counter getCounter(Mapper.Context context, String k, String t) {
        return context.getCounter(k, t);
    }
}

