package eu.dnetlib.data.mapreduce.hbase.dli.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import com.google.common.collect.ComparisonChain;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

/**
 * Created by claudio on 13/03/2017.
 */
public class DliKey implements WritableComparable<DliKey> {

	public final static int ENTITY = 0;
	public final static int REL = 1;

	private IntWritable keyType;

	private Text id;

	public DliKey() {}

	public static DliKey create(final int keyType, final String id) {
		return new DliKey(keyType, id);
	}

	public static DliKey rel(final String id) {
		return new DliKey(REL, id);
	}

	public static DliKey entity(final String id) {
		return new DliKey(ENTITY, id);
	}

	public DliKey(final int keyType, final String id) {
		this.id = new Text(id);
		this.keyType = new IntWritable(keyType);
	}

	public void setKeyType(final IntWritable keyType) {
		this.keyType = keyType;
	}

	public void setId(final Text id) {
		this.id = id;
	}

	public Text getId() {
		return id;
	}

	public IntWritable getKeyType() {
		return keyType;
	}

	@Override
	public int compareTo(final DliKey o) {
		final int res = ComparisonChain.start()
				.compare(getId(), o.getId())
				.compare(getKeyType(), o.getKeyType())
				.result();

		//System.out.println(String.format("%s.compareTo(%s) = %s", toString(), o.toString(), res));
		return res;
	}

	@Override
	public void write(final DataOutput out) throws IOException {
		keyType.write(out);
		id.write(out);
	}

	@Override
	public void readFields(final DataInput in) throws IOException {
		keyType = new IntWritable();
		keyType.readFields(in);
		id = new Text();
		id.readFields(in);
	}

	@Override
	public String toString() {
		return (new StringBuilder())
				.append('{')
				.append(getKeyType().get())
				.append(',')
				.append(getId())
				.append('}')
				.toString();
	}
}
