/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.gson.Gson;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.hbase.broker.Pid;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.model.Dataset;
import eu.dnetlib.data.mapreduce.hbase.broker.model.ESEvent;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMap;
import eu.dnetlib.data.mapreduce.hbase.broker.model.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.model.Provenance;
import eu.dnetlib.data.mapreduce.hbase.broker.model.Publication;
import eu.dnetlib.data.mapreduce.hbase.dli.kv.DliKey;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DatasetRelationEnrichmentMapper
extends TableMapper<DliKey, Text> {
    protected Text outValue;
    protected DliKey outKey;
    private Gson gson;
    private static String UNKNOWN_REPO_ID = "openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18";

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.outKey = new DliKey();
        this.outValue = new Text();
        this.gson = new Gson();
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = DNGFRowKeyDecoder.decode((byte[])key.copyBytes()).getType();
        DNGFProtos.DNGF entity = HBaseTableDAO.getMetadata(value, type);
        if (entity == null || entity.getEntity() == null) {
            return;
        }
        DNGFProtos.DNGFEntity mainEntity = entity.getEntity();
        if (mainEntity.getType() == TypeProtos.Type.unknown) {
            return;
        }
        List targetPids = ((List)mainEntity.getExtension(DliProtos.typedIdentifier)).stream().map(id -> new Pid(id.getQualifier().getClassid(), id.getValue())).filter(Dataset.distinctByKey(pid -> String.format("%s::%s", pid.getPidType().toLowerCase(), pid.getPid().toLowerCase()))).collect(Collectors.toList());
        if (targetPids.size() == 0) {
            throw new RuntimeException("Empty target pid");
        }
        Publication targetPublication = new Publication();
        if (mainEntity.getType() == TypeProtos.Type.dataset) {
            targetPublication.setDatasets(Collections.singletonList(Dataset.DatasetFromDNGF(mainEntity)));
        } else {
            targetPublication.setPublications(Collections.singletonList(Publication.fromDNGF(mainEntity)));
        }
        targetPublication.setOriginalId(((Pid)targetPids.get(0)).getPid());
        this.emit(0, mainEntity.getId(), context, this.gson.toJson((Object)targetPublication));
        if (this.isValid(entity) && !this.deletedByInference(entity) && mainEntity.getType() == TypeProtos.Type.dataset) {
            OpenAireEventPayload payload = new OpenAireEventPayload();
            Provenance prov = new Provenance();
            prov.setRepositoryName("ScholExplorer");
            payload.setProvenance(prov);
            payload.setTrust(0.9f);
            mainEntity.getDataset().getInstanceList().forEach(i -> {
                FieldTypeProtos.KeyValue hb = i.getHostedby();
                if (hb != null && StringUtils.isNotBlank((CharSequence)hb.getKey()) && !UNKNOWN_REPO_ID.equals(hb.getKey())) {
                    HBaseTableDAO.rel(value, "isMergedIn", "merges", "isSimilarTo").values().forEach(r -> {
                        long count;
                        if (!this.deletedByInference((DNGFProtos.DNGF)r) && !r.getRel().getTarget().startsWith("70") && (count = r.getRel().getCollectedfromList().stream().filter(cf_rel -> cf_rel.getKey().equals(hb.getKey())).count()) == 0L) {
                            Topic topic;
                            EventMap em = new EventMap();
                            em.setTarget_datasource_id(this.generateDSId(hb.getKey()));
                            em.setTarget_datasource_name(hb.getValue());
                            em.setProvenance_datasource_id("10|openaire____::e034d6a11054f5ade9221ebac484e864");
                            em.setProvenance_datasource_name("ScholExplorer");
                            em.setTrust(0.9f);
                            if (r.getRel().getTarget().startsWith("50")) {
                                switch (r.getRel().getRelType().getClassname().toLowerCase()) {
                                    case "issupplementto": {
                                        topic = Topic.ENRICH_MISSING_PUBLICATION_IS_SUPPLEMENTED_TO;
                                        break;
                                    }
                                    case "issupplementedby": {
                                        topic = Topic.ENRICH_MISSING_PUBLICATION_IS_SUPPLEMENTED_BY;
                                        break;
                                    }
                                    case "references": {
                                        topic = Topic.ENRICH_MISSING_PUBLICATION_REFERENCES;
                                        break;
                                    }
                                    case "isreferencedby": {
                                        topic = Topic.ENRICH_MISSING_PUBLICATION_IS_REFERENCED_BY;
                                        break;
                                    }
                                    default: {
                                        topic = Topic.ENRICH_MISSING_PUBLICATION_IS_RELATED_TO;
                                        break;
                                    }
                                }
                            } else {
                                switch (r.getRel().getRelType().getClassname().toLowerCase()) {
                                    case "issupplementto": {
                                        topic = Topic.ENRICH_MISSING_DATASET_IS_SUPPLEMENTED_TO;
                                        break;
                                    }
                                    case "issupplementedby": {
                                        topic = Topic.ENRICH_MISSING_DATASET_IS_SUPPLEMENTED_BY;
                                        break;
                                    }
                                    case "references": {
                                        topic = Topic.ENRICH_MISSING_DATASET_REFERENCES;
                                        break;
                                    }
                                    case "isreferencedby": {
                                        topic = Topic.ENRICH_MISSING_DATASET_IS_REFERENCED_BY;
                                        break;
                                    }
                                    default: {
                                        topic = Topic.ENRICH_MISSING_DATASET_IS_RELATED_TO;
                                    }
                                }
                            }
                            context.getCounter("Broker Enrichment", topic.toString()).increment(1L);
                            Publication sourcePublication = Publication.fromDNGF(mainEntity);
                            sourcePublication.setCollectedFrom(Collections.singletonList(hb.getValue()));
                            payload.setPublication(sourcePublication);
                            ESEvent rel_event = new ESEvent();
                            rel_event.setTopic(topic.getValue());
                            rel_event.setCreationDate(new Date());
                            rel_event.setMap(em);
                            rel_event.setPayload(this.gson.toJson((Object)payload));
                            this.emit(1, r.getRel().getTarget(), context, this.gson.toJson((Object)rel_event));
                        }
                    });
                }
            });
        }
    }

    private String generateDSId(String currentId) {
        String nsPrefix = StringUtils.substringBefore((String)currentId, (String)"::");
        String id = AbstractDNetXsltFunctions.md5((String)StringUtils.substringAfter((String)currentId, (String)"::"));
        return String.format("10|%s::%s", nsPrefix, id);
    }

    private boolean isValid(DNGFProtos.DNGF entity) {
        return entity != null && entity.isInitialized();
    }

    private boolean deletedByInference(DNGFProtos.DNGF oaf) {
        return oaf.getDataInfo().getDeletedbyinference();
    }

    private void emit(int keyType, String id, Mapper.Context context, String item) {
        try {
            this.outKey.setKeyType(new IntWritable(keyType));
            this.outKey.setId(new Text(id));
            this.outValue.set(item);
            context.write((Object)DliKey.create(keyType, id), (Object)this.outValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

