/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupRootsToCsvMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(DedupRootsToCsvMapper.class);
    private DedupConfig dedupConf;
    private ImmutableBytesWritable key;
    private ImmutableBytesWritable value;

    protected void setup(Mapper.Context context) {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup buildRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.key = new ImmutableBytesWritable();
        this.value = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable rowkey, Result result, Mapper.Context context) throws IOException, InterruptedException {
        if (HBaseTableDAO.isRoot(rowkey)) {
            context.getCounter(this.dedupConf.getWf().getEntityType(), "root row skipped").increment(1L);
            return;
        }
        NavigableMap entityCf = result.getFamilyMap(Bytes.toBytes((String)this.dedupConf.getWf().getEntityType()));
        if (MapUtils.isEmpty((Map)entityCf) && entityCf.get(HBaseTableDAO.cfMetadataByte()) == null) {
            context.getCounter(this.dedupConf.getWf().getEntityType(), "missing body").increment(1L);
            return;
        }
        NavigableMap mergedIn = result.getFamilyMap(HBaseTableDAO.getDedupQualifier_mergedInBytes(this.dedupConf.getWf().getEntityType()));
        if (MapUtils.isEmpty((Map)mergedIn)) {
            context.getCounter(this.dedupConf.getWf().getEntityType(), "missing mergedIn relationship").increment(1L);
            return;
        }
        String rootId = new String((byte[])Iterables.getOnlyElement(mergedIn.keySet()), Charset.forName("UTF-8"));
        byte[] body = (byte[])entityCf.get(HBaseTableDAO.cfMetadataByte());
        this.key.set(Bytes.toBytes((String)rootId));
        this.value.set(Bytes.toBytes((String)((String)Iterables.getOnlyElement((Iterable)DNGFDecoder.decode((byte[])body).getEntity().getOriginalIdList()))));
        context.write((Object)this.key, (Object)this.value);
        context.getCounter(this.dedupConf.getWf().getEntityType(), "root entity").increment(1L);
    }
}

