/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dli.kv;

import com.google.common.collect.ComparisonChain;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class DliKey
implements WritableComparable<DliKey> {
    public static final int ENTITY = 0;
    public static final int REL = 1;
    private IntWritable keyType;
    private Text id;

    public DliKey() {
    }

    public static DliKey create(int keyType, String id) {
        return new DliKey(keyType, id);
    }

    public static DliKey rel(String id) {
        return new DliKey(1, id);
    }

    public static DliKey entity(String id) {
        return new DliKey(0, id);
    }

    public DliKey(int keyType, String id) {
        this.id = new Text(id);
        this.keyType = new IntWritable(keyType);
    }

    public void setKeyType(IntWritable keyType) {
        this.keyType = keyType;
    }

    public void setId(Text id) {
        this.id = id;
    }

    public Text getId() {
        return this.id;
    }

    public IntWritable getKeyType() {
        return this.keyType;
    }

    public int compareTo(DliKey o) {
        int res = ComparisonChain.start().compare((Comparable)this.getId(), (Comparable)o.getId()).compare((Comparable)this.getKeyType(), (Comparable)o.getKeyType()).result();
        return res;
    }

    public void write(DataOutput out) throws IOException {
        this.keyType.write(out);
        this.id.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.keyType = new IntWritable();
        this.keyType.readFields(in);
        this.id = new Text();
        this.id.readFields(in);
    }

    public String toString() {
        return "" + '{' + this.getKeyType().get() + ',' + this.getId() + '}';
    }
}

