/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.common.collect.Lists;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.transform.SolrProtoMapper;
import eu.dnetlib.miscutils.datetime.HumanTime;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.DocumentException;

public class DedupIndexFeedMapper
extends TableMapper<Text, Text> {
    private static final Log log = LogFactory.getLog(DedupIndexFeedMapper.class);
    private static final String outFormat = new String("yyyy-MM-dd'T'hh:mm:ss'Z'");
    private static final List<String> dateFormats = Arrays.asList("yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd", "dd-MM-yyyy", "dd/MM/yyyy", "yyyy");
    private CloudSolrServer solrServer;
    private String dsId;
    private String version;
    private int shutdownWaitTime = 10000;
    private int bufferFlushThreshold = 100;
    private List<SolrInputDocument> buffer;
    private int backoffTimeMs = 5000;
    private boolean simulation = false;
    private String entityType = null;
    private String actionset = null;
    private SolrProtoMapper mapper = null;
    private static final int MAX_RETRIES = 10;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.logConfiguration(context.getConfiguration());
        this.shutdownWaitTime = Integer.parseInt(context.getConfiguration().get("index.shutdown.wait.time"));
        this.bufferFlushThreshold = Integer.parseInt(context.getConfiguration().get("index.buffer.flush.threshold"));
        this.dsId = context.getConfiguration().get("id");
        this.version = this.getParsedDateField(context.getConfiguration().get("index.feed.timestamp"));
        this.buffer = Lists.newArrayList();
        this.simulation = Boolean.parseBoolean(context.getConfiguration().get("index.solr.sim.mode"));
        this.entityType = context.getConfiguration().get("entityType");
        this.actionset = context.getConfiguration().get("actionset");
        String fields = context.getConfiguration().get("index.fields");
        log.info((Object)("got fields: \n" + fields));
        log.info((Object)("got dsId: " + this.dsId));
        log.info((Object)("got version: " + this.version));
        log.info((Object)("simulation: " + this.simulation));
        log.info((Object)("entityType: " + this.entityType));
        log.info((Object)("actionset: " + this.actionset));
        log.info((Object)("buffer size: " + this.bufferFlushThreshold));
        try {
            this.mapper = new SolrProtoMapper(fields);
        }
        catch (DocumentException e) {
            log.error((Object)("unable to parse fields: " + fields));
            throw new IllegalArgumentException(e);
        }
        String baseURL = context.getConfiguration().get("index.solr.url");
        log.info((Object)("solr server baseURL: " + baseURL));
        String collection = context.getConfiguration().get("index.solr.collection");
        log.info((Object)("solr server collection: " + collection));
        while (true) {
            try {
                log.info((Object)"initializing solr server...");
                this.solrServer = new CloudSolrServer(baseURL);
                this.solrServer.connect();
                this.solrServer.setParallelUpdates(true);
                this.solrServer.setDefaultCollection(collection);
                SolrPingResponse rsp = this.solrServer.ping();
                if (rsp.getStatus() != 0) {
                    throw new SolrServerException("bad init status: " + rsp.getStatus());
                }
            }
            catch (Throwable e) {
                if (this.solrServer != null) {
                    this.solrServer.shutdown();
                }
                context.getCounter("index init", e.getMessage()).increment(1L);
                log.info((Object)String.format("failed to init solr client wait %dms", this.backoffTimeMs));
                Thread.sleep(this.backoffTimeMs);
                continue;
            }
            break;
        }
        log.info((Object)"setup completed, solr server initialization done.");
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        int retries;
        SolrInputDocument doc = null;
        NavigableMap bMap = value.getFamilyMap(Bytes.toBytes((String)this.entityType));
        if (MapUtils.isEmpty((Map)bMap) || !bMap.containsKey(HBaseTableDAO.cfMetadataByte())) {
            context.getCounter(this.entityType, "missing body");
            return;
        }
        DNGFProtos.DNGF oaf = DNGFProtos.DNGF.parseFrom((byte[])((byte[])bMap.get(HBaseTableDAO.cfMetadataByte())));
        try {
            doc = this.getDocument(oaf);
        }
        catch (Throwable e) {
            new JsonFormat();
            this.handleError(key, JsonFormat.printToString((Message)oaf), context, doc, e);
            return;
        }
        for (retries = 0; retries < 10; ++retries) {
            try {
                this.addDocument(context, doc);
                return;
            }
            catch (Throwable e) {
                context.getCounter("index feed", "retries").increment(1L);
                new JsonFormat();
                this.handleError(key, JsonFormat.printToString((Message)oaf), context, doc, e);
                log.info((Object)String.format("failed to feed documents, waiting %dms", this.backoffTimeMs));
                Thread.sleep(this.backoffTimeMs);
                continue;
            }
        }
        if (retries >= 10) {
            throw new IOException("too many retries: " + retries);
        }
    }

    private SolrInputDocument getDocument(DNGFProtos.DNGF oaf) throws DocumentException {
        SolrInputDocument document = this.mapper.map((GeneratedMessage)oaf, this.version, this.dsId, this.actionset);
        document.addField("actionset", (Object)this.actionset);
        return document;
    }

    private void addDocument(Mapper.Context context, SolrInputDocument doc) throws SolrServerException, IOException {
        if (!doc.isEmpty()) {
            this.buffer.add(doc);
            if (this.buffer.size() >= this.bufferFlushThreshold) {
                this.doAdd(this.buffer, context);
            }
        } else {
            context.getCounter("index feed", "skipped records").increment(1L);
        }
    }

    private void doAdd(List<SolrInputDocument> buffer, Mapper.Context context) throws SolrServerException, IOException {
        if (!this.simulation) {
            long start = System.currentTimeMillis();
            UpdateResponse rsp = this.solrServer.add(buffer);
            long stop = System.currentTimeMillis() - start;
            log.info((Object)("feed time for " + buffer.size() + " records : " + HumanTime.exactly((long)stop) + "\n"));
            int status = rsp.getStatus();
            context.getCounter("index feed", "status code: " + status).increment((long)buffer.size());
            if (status != 0) {
                throw new SolrServerException("bad status: " + status);
            }
        }
        buffer.clear();
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        try {
            if (!this.buffer.isEmpty()) {
                this.doAdd(this.buffer, context);
            }
            log.info((Object)("\nwaiting " + this.shutdownWaitTime + "ms before shutdown"));
            Thread.sleep(this.shutdownWaitTime);
            this.solrServer.shutdown();
        }
        catch (SolrServerException e) {
            System.err.println("couldn't shutdown server " + e.getMessage());
        }
    }

    public String getParsedDateField(String date) {
        for (String formatString : dateFormats) {
            try {
                return new SimpleDateFormat(outFormat).format(new SimpleDateFormat(formatString).parse(date));
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalStateException("unable to parse date: " + date);
    }

    private void handleError(ImmutableBytesWritable key, String value, Mapper.Context context, SolrInputDocument doc, Throwable e) throws IOException, InterruptedException {
        context.getCounter("index feed", e.getClass().getName()).increment(1L);
        context.write((Object)new Text(key.copyBytes()), (Object)this.printRottenRecord(context.getTaskAttemptID().toString(), value, doc));
        e.printStackTrace(System.err);
    }

    private Text printRottenRecord(String taskid, String value, SolrInputDocument doc) {
        return new Text("\n**********************************\ntask: " + taskid + "\n" + this.check("original", value.toString() + this.check("solrDoc", doc)));
    }

    private String check(String label, Object value) {
        if (value != null && !value.toString().isEmpty()) {
            return "\n " + label + ":\n" + value + "\n";
        }
        return "\n";
    }

    private void logConfiguration(Configuration conf) {
        log.info((Object)"job configutation #################");
        for (Map.Entry e : conf) {
            log.info((Object)("'" + (String)e.getKey() + "' : '" + (String)e.getValue() + "'"));
        }
        log.info((Object)"end of job configutation #################\n\n");
    }
}

