/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.wds;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.WdsPublicationProtos;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class ExtendProjectInfoMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    private ImmutableBytesWritable outKey = new ImmutableBytesWritable();
    private ImmutableBytesWritable outValue = new ImmutableBytesWritable();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws InvalidProtocolBufferException {
        DNGFProtos.DNGF entity;
        List projects;
        TypeProtos.Type type = DNGFRowKeyDecoder.decode((byte[])rowkey.copyBytes()).getType();
        if (type == TypeProtos.Type.publication && (projects = (List)(entity = HBaseTableDAO.getMetadata(value, type)).getEntity().getPublication().getMetadata().getExtension(WdsPublicationProtos.WdsPublication.projects)) != null && projects.size() > 0) {
            context.getCounter("Projet", "found").increment(1L);
            HBaseTableDAO.rel(value, "isMergedIn", "merges", "isSimilarTo").values().forEach(r -> projects.forEach(p -> this.emit(r.getRel().getTarget(), context, p.toByteArray(), type)));
        }
        if (type == TypeProtos.Type.dataset && (entity = HBaseTableDAO.getMetadata(value, type)) != null) {
            this.emit(entity.getEntity().getId(), context, entity.getEntity().toByteArray(), type);
        }
    }

    private void emit(String id, Mapper.Context context, byte[] data, TypeProtos.Type type) {
        try {
            if (type.equals((Object)TypeProtos.Type.publication)) {
                context.getCounter("Project", "emmitted").increment(1L);
            } else {
                context.getCounter("Dataset", "emmitted").increment(1L);
            }
            this.outKey.set(Bytes.toBytes((String)id));
            this.outValue.set(data);
            context.write((Object)this.outKey, (Object)this.outValue);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

