/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupDeleteSimRelMapper
extends TableMapper<ImmutableBytesWritable, Writable> {
    private DedupConfig dedupConf;
    private ImmutableBytesWritable outKey;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.outKey = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType());
        NavigableMap similarRels = value.getFamilyMap(HBaseTableDAO.getSimilarityQualifierBytes(type));
        if (similarRels != null && !similarRels.isEmpty()) {
            byte[] row = rowkey.copyBytes();
            Delete delete = new Delete(row);
            for (byte[] q : similarRels.keySet()) {
                delete.deleteColumns(HBaseTableDAO.getSimilarityQualifierBytes(type), q);
            }
            this.outKey.set(row);
            context.write((Object)this.outKey, (Object)delete);
            context.getCounter(this.dedupConf.getWf().getEntityType(), "similarity deleted").increment((long)similarRels.size());
        } else {
            context.getCounter(this.dedupConf.getWf().getEntityType(), "row not in similarity mesh").increment(1L);
        }
    }
}

