/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.gt.GTAuthor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupFindRootsPersonMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    private DedupConfig dedupConf;
    private ImmutableBytesWritable outKey;
    private ImmutableBytesWritable outValue;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.outKey = new ImmutableBytesWritable();
        this.outValue = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type;
        NavigableMap similarRels;
        DNGFRowKeyDecoder rkd = DNGFRowKeyDecoder.decode((byte[])rowkey.copyBytes());
        if (!TypeProtos.Type.person.equals((Object)rkd.getType())) {
            context.getCounter(rkd.getType().toString(), "skipped").increment(1L);
        }
        if ((similarRels = value.getFamilyMap(HBaseTableDAO.getSimilarityQualifierBytes(type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType())))) != null && !similarRels.isEmpty()) {
            ByteBuffer min = this.findMin(rowkey.copyBytes(), similarRels.keySet());
            byte[] groupingKey = HBaseTableDAO.newIdBytes(min, this.dedupConf.getWf().getDedupRun());
            GTAuthor gta = this.asGTA(rowkey, value.getValue(Bytes.toBytes((String)this.dedupConf.getWf().getEntityType()), HBaseTableDAO.cfMetadataByte()));
            this.emitBody(context, groupingKey, gta);
        } else {
            context.getCounter(this.dedupConf.getWf().getEntityType(), "row not in similarity mesh").increment(1L);
        }
    }

    private GTAuthor asGTA(ImmutableBytesWritable rowkey, byte[] input) {
        DNGFDecoder decoder = DNGFDecoder.decode((byte[])input);
        DNGFProtos.DNGF oaf = decoder.getDNGF();
        PersonProtos.Person person = oaf.getEntity().getPerson();
        new JsonFormat();
        GTAuthor gta = GTAuthor.fromDNGFJson((String)JsonFormat.printToString((Message)person));
        String id = new String(rowkey.copyBytes());
        gta.setId(id);
        gta.getAuthor().setId(id);
        return gta;
    }

    private ByteBuffer findMin(byte[] key, Iterable<byte[]> keys) {
        ByteBuffer bb = ByteBuffer.wrap(key);
        for (byte[] q : keys) {
            ByteBuffer iq = ByteBuffer.wrap(q);
            if (bb.compareTo(iq) <= 0) continue;
            bb = iq;
        }
        return bb;
    }

    private void emitBody(Mapper.Context context, byte[] row, GTAuthor gta) throws IOException, InterruptedException {
        this.outKey.set(row);
        this.outValue.set(this.toDNGFByteArray(gta));
        context.write((Object)this.outKey, (Object)this.outValue);
        context.getCounter(this.dedupConf.getWf().getEntityType(), "in").increment(1L);
    }

    public byte[] toDNGFByteArray(GTAuthor gta) {
        return Bytes.toBytes((String)gta.toString());
    }
}

