/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

import eu.dnetlib.data.mapreduce.hbase.dedup.cc.VertexWritable;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class MindistSearchReducer
extends Reducer<Text, VertexWritable, Text, VertexWritable> {
    private static final Log log = LogFactory.getLog(MindistSearchReducer.class);
    public static final String UPDATE_COUNTER = "UpdateCounter";
    public static final String SKIPPED = "SKIPPED";
    public static final String UPDATED = "UPDATED";
    private boolean depthOne;
    private boolean debug = false;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String recursionDepth = context.getConfiguration().get("mindist_recursion_depth");
        log.info((Object)("got recursion depth: " + recursionDepth));
        if (Integer.parseInt(recursionDepth) == 0) {
            this.depthOne = true;
        }
        this.debug = context.getConfiguration().getBoolean("mindist_DEBUG", false);
        log.info((Object)("debug mode: " + this.debug));
    }

    protected void reduce(Text key, Iterable<VertexWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        VertexWritable realVertex = null;
        Text currentMinimalKey = null;
        if (this.depthOne) {
            for (VertexWritable vertex : values) {
                if (vertex.isMessage()) continue;
                realVertex = vertex.clone();
            }
            if (realVertex == null) {
                context.getCounter(UPDATE_COUNTER, SKIPPED).increment(1L);
                return;
            }
            realVertex.setActivated(true);
            realVertex.setVertexId(realVertex.getEdges().first());
            if (key.compareTo((BinaryComparable)realVertex.getVertexId()) < 0) {
                realVertex.setVertexId(key);
            }
            context.getCounter(UPDATE_COUNTER, UPDATED).increment(1L);
        } else {
            for (VertexWritable vertex : values) {
                if (!vertex.isMessage()) {
                    if (realVertex != null) continue;
                    realVertex = vertex.clone();
                    continue;
                }
                if (currentMinimalKey == null) {
                    currentMinimalKey = new Text(vertex.getVertexId());
                    continue;
                }
                if (currentMinimalKey.compareTo((BinaryComparable)vertex.getVertexId()) <= 0) continue;
                currentMinimalKey = new Text(vertex.getVertexId());
            }
            if (realVertex == null) {
                context.getCounter(UPDATE_COUNTER, SKIPPED).increment(1L);
                return;
            }
            if (currentMinimalKey != null && currentMinimalKey.compareTo((BinaryComparable)realVertex.getVertexId()) < 0) {
                realVertex.setVertexId(currentMinimalKey);
                realVertex.setActivated(true);
                context.getCounter(UPDATE_COUNTER, UPDATED).increment(1L);
            } else {
                realVertex.setActivated(false);
            }
        }
        context.write((Object)key, (Object)realVertex);
        if (this.debug) {
            log.info((Object)realVertex.toJSON());
        }
    }
}

