/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class DNGFKey
implements Writable,
WritableComparable<DNGFKey> {
    public static final int MERGES_REL = 0;
    public static final int OTHER_REL = 1;
    private IntWritable keyType;
    private Text id;

    public DNGFKey() {
    }

    public DNGFKey(int keyType, String id) {
        this.id = new Text(id);
        this.keyType = new IntWritable(keyType);
    }

    public static DNGFKey create(int keyType, String id) {
        return new DNGFKey(keyType, id);
    }

    public static DNGFKey mergesRel(String id) {
        return new DNGFKey(0, id);
    }

    public static DNGFKey otherRel(String id) {
        return new DNGFKey(1, id);
    }

    public Text getId() {
        return this.id;
    }

    public void setId(Text id) {
        this.id = id;
    }

    public IntWritable getKeyType() {
        return this.keyType;
    }

    public void setKeyType(IntWritable keyType) {
        this.keyType = keyType;
    }

    public int compareTo(DNGFKey o) {
        int compareValue = this.id.toString().compareTo(o.getId().toString());
        if (compareValue == 0) {
            compareValue = this.keyType.compareTo(o.getKeyType());
        }
        return compareValue;
    }

    public void write(DataOutput out) throws IOException {
        this.keyType.write(out);
        this.id.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.keyType = new IntWritable();
        this.keyType.readFields(in);
        this.id = new Text();
        this.id.readFields(in);
    }

    public String toString() {
        return "" + '{' + this.getKeyType().get() + ',' + this.getId() + '}';
    }
}

