/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dli;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.dli.kv.DliKey;
import eu.dnetlib.data.proto.dli.Scholix2ObjectProtos;
import eu.dnetlib.data.proto.dli.ScholixObjectProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.dli.proto.ScholixVersion;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PrepareScholixDataReducer
extends Reducer<DliKey, ImmutableBytesWritable, Text, Text> {
    private static final Log log = LogFactory.getLog(PrepareScholixDataReducer.class);
    private Text outKey;
    private Text outValue;
    private ScholixVersion scholixVersion;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.outKey = new Text("");
        this.outValue = new Text();
        this.scholixVersion = ScholixVersion.valueOf((String)context.getConfiguration().get("ScholixVersion"));
    }

    protected void reduce(DliKey key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Iterator<ImmutableBytesWritable> it = values.iterator();
        ImmutableBytesWritable first = it.next();
        AtomicInteger groupSize = new AtomicInteger(1);
        switch (this.scholixVersion) {
            case v1: {
                ScholixObjectProtos.Scholix source = this.parsev1(key, first).build();
                if (!source.hasSource()) {
                    context.getCounter("scholix", "missing source").increment(1L);
                    return;
                }
                it.forEachRemaining(t -> {
                    groupSize.incrementAndGet();
                    ScholixObjectProtos.Scholix.Builder rel = this.parsev1(key, (ImmutableBytesWritable)t);
                    if (rel.hasTarget()) {
                        rel.setSource(source.getSource());
                        rel.setIdentifier(this.generateScholixIdentifier(rel));
                        this.emit(context, JsonFormat.printToString((Message)rel.build()));
                    } else {
                        context.getCounter("scholix", "missing target").increment(1L);
                    }
                });
                break;
            }
            case v2: {
                Scholix2ObjectProtos.Scholix source = this.parsev2(key, first).build();
                if (!source.hasSource()) {
                    context.getCounter("scholix", "missing source").increment(1L);
                    return;
                }
                it.forEachRemaining(t -> {
                    groupSize.incrementAndGet();
                    Scholix2ObjectProtos.Scholix.Builder rel = this.parsev2(key, (ImmutableBytesWritable)t);
                    if (rel.hasTarget()) {
                        rel.setSource(source.getSource());
                        this.emit(context, JsonFormat.printToString((Message)rel.build()));
                    } else {
                        context.getCounter("scholix", "missing target").increment(1L);
                    }
                });
                break;
            }
        }
        this.groupSizeCounter(context, groupSize.get(), "1,1", "1,10", "10,20", "20,100", "100,200", "200,500", "500,1000", "1000,2000", "2000,5000", "5000,10000", "10000,20000", "20000,*");
    }

    private void groupSizeCounter(Reducer.Context context, int groupSize, String ... groups) {
        Arrays.asList(groups).forEach(g -> {
            LinkedList i = Lists.newLinkedList((Iterable)Splitter.on((String)",").split((CharSequence)g));
            int min = Integer.parseInt((String)i.getFirst());
            int max = ((String)i.getLast()).equals("*") ? Integer.MAX_VALUE : Integer.parseInt((String)i.getLast());
            this.groupSizeCounter(context, groupSize, min, max);
        });
    }

    private void groupSizeCounter(Reducer.Context context, int groupSize, Integer min, Integer max) {
        if (groupSize > min & groupSize <= max) {
            context.getCounter("scholix groups", String.format("group size (%s,%s)", min, max)).increment(1L);
        }
    }

    private ScholixObjectProtos.Scholix.Builder parsev1(DliKey key, ImmutableBytesWritable value) {
        try {
            return ScholixObjectProtos.Scholix.newBuilder((ScholixObjectProtos.Scholix)ScholixObjectProtos.Scholix.parseFrom((byte[])value.copyBytes()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(String.format("cannot parse Scholix, keytype '%s', id '%s'", key.getKeyType(), key.getId()));
        }
    }

    private String generateScholixIdentifier(ScholixObjectProtos.Scholix.Builder scholix) {
        String relname = scholix.getRelationship().getName();
        String sourceId = scholix.getSource().getDnetIdentifier();
        String targetId = scholix.getTarget().getDnetIdentifier();
        return AbstractDNetXsltFunctions.md5((String)String.format("%s::%s::%s", sourceId, relname, targetId));
    }

    private Scholix2ObjectProtos.Scholix.Builder parsev2(DliKey key, ImmutableBytesWritable value) {
        try {
            return Scholix2ObjectProtos.Scholix.newBuilder((Scholix2ObjectProtos.Scholix)Scholix2ObjectProtos.Scholix.parseFrom((byte[])value.copyBytes()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(String.format("cannot parse Scholix, keytype '%s', id '%s'", key.getKeyType(), key.getId()));
        }
    }

    private void emit(Reducer.Context context, String data) {
        this.outValue.set(data.getBytes());
        try {
            context.write((Object)this.outKey, (Object)this.outValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

