/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class DocumentDatabaseMapper
extends Mapper<Text, Text, Text, Text> {
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.logConfiguration(context.getConfiguration());
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(value.toString()));
            String id = doc.valueOf("//dri:objIdentifier");
            this.addDocument(context, id, value.toString());
            context.getCounter("Document Database", "records").increment(1L);
        }
        catch (Exception e) {
            context.getCounter("Document Database", "errors").increment(1L);
            context.write((Object)key, (Object)value);
            e.printStackTrace(System.err);
        }
    }

    private void addDocument(Mapper.Context context, String id, String string) {
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
    }

    private void logConfiguration(Configuration conf) {
        System.out.println("job configutation #################");
        for (Map.Entry e : conf) {
            System.out.println("'" + (String)e.getKey() + "' : '" + (String)e.getValue() + "'");
        }
        System.out.println("end of job configutation #################\n\n");
    }
}

