/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.XmlFormat;
import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.model.DNGFEntityDecoder;
import eu.dnetlib.data.graph.model.DNGFRelDecoder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextDef;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.mapreduce.util.AbstractRecordFactory;
import eu.dnetlib.data.mapreduce.util.TemplateFactory;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.WdsDatasetProtos;
import eu.dnetlib.data.transform.Ontologies;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;

public class XmlRecordFactory
extends AbstractRecordFactory {
    protected TemplateFactory templateFactory = new TemplateFactory();
    protected List<String> extraInfo = Lists.newArrayList();
    protected Transformer transformer;
    private final String schemaLocation;

    public XmlRecordFactory(EntityConfigTable entityConfigTable, ContextMapper contextMapper, Ontologies ontologies, String schemaLocation, boolean entityDefaults, boolean relDefaults, boolean childDefeaults) throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        super(entityConfigTable, contextMapper, ontologies, entityDefaults, relDefaults, childDefeaults);
        this.schemaLocation = schemaLocation;
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.transformer.setOutputProperty("omit-xml-declaration", "yes");
    }

    public static String escapeXml(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    @Override
    public String build() {
        try {
            DNGFEntityDecoder entity = this.mainEntity.decodeEntity();
            TypeProtos.Type type = entity.getType();
            List<String> metadata = this.decodeType(entity, null, this.entityDefaults, false);
            List<String> rels = this.listRelations();
            metadata.addAll(this.buildContexts(type));
            metadata.add(this.parseDataInfo(this.mainEntity));
            String body = this.templateFactory.buildBody(type, metadata, rels, this.listChildren(), this.extraInfo);
            return this.templateFactory.buildRecord(type, this.key, entity.getDateOfCollection(), entity.getDateOfTransformation(), this.schemaLocation, body, this.countersAsXml());
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("error building record '%s'", this.key), e);
        }
    }

    private String parseDataInfo(DNGFDecoder decoder) {
        FieldTypeProtos.DataInfo dataInfo = decoder.getDNGF().getDataInfo();
        StringBuilder sb = new StringBuilder();
        sb.append("<datainfo>");
        sb.append(this.asXmlElement("inferred", dataInfo.getInferred() + "", null, null));
        sb.append(this.asXmlElement("deletedbyinference", dataInfo.getDeletedbyinference() + "", null, null));
        sb.append(this.asXmlElement("trust", dataInfo.getTrust() + "", null, null));
        sb.append(this.asXmlElement("inferenceprovenance", dataInfo.getInferenceprovenance() + "", null, null));
        sb.append(this.asXmlElement("provenanceaction", null, dataInfo.getProvenanceaction(), null));
        sb.append("</datainfo>");
        return sb.toString();
    }

    private List<String> decodeType(DNGFEntityDecoder decoder, Set<String> filter, boolean defaults, boolean expandingRel) {
        ArrayList metadata = Lists.newArrayList();
        metadata.addAll(this.listFields(decoder.getMetadata(), filter, defaults, expandingRel));
        metadata.addAll(this.listFields(decoder.getDNGFEntity(), filter, defaults, expandingRel));
        if (decoder.getEntity() instanceof PublicationProtos.Publication && !expandingRel) {
            metadata.add(this.asXmlElement("bestlicense", "", this.getBestLicense(), null));
            metadata.addAll(this.listFields(decoder.getEntity(), filter, defaults, expandingRel));
        }
        if (decoder.getEntity() instanceof PersonProtos.Person && !expandingRel) {
            metadata.addAll(this.listFields(decoder.getEntity(), filter, defaults, expandingRel));
        }
        if (decoder.getEntity() instanceof ProjectProtos.Project && !expandingRel) {
            metadata.addAll(this.listFields(decoder.getEntity(), filter, defaults, expandingRel));
        }
        return metadata;
    }

    private List<String> listRelations() {
        ArrayList rels = Lists.newArrayList();
        for (DNGFDecoder decoder : this.relations) {
            DNGFProtos.DNGFRel rel = decoder.getDNGFRel();
            DNGFProtos.DNGFEntity cachedTarget = rel.getCachedTarget();
            DNGFRelDecoder relDecoder = DNGFRelDecoder.decode((DNGFProtos.DNGFRel)rel);
            if (!relDecoder.getRelSourceId().equals(this.key) && !relDecoder.getRelTargetId().equals(this.key)) continue;
            ArrayList metadata = Lists.newArrayList();
            TypeProtos.Type targetType = relDecoder.getTargetType();
            Set<String> relFilter = this.entityConfigTable.getFilter(targetType, relDecoder.getRelDescriptor());
            metadata.addAll(this.listFields((GeneratedMessage)relDecoder.getDngfRel(), relFilter, false, true));
            RelDescriptor relDescriptor = relDecoder.getRelDescriptor();
            if (cachedTarget != null && cachedTarget.isInitialized()) {
                Set<String> filter = this.entityConfigTable.getFilter(targetType, relDescriptor);
                metadata.addAll(this.decodeType(DNGFEntityDecoder.decode((DNGFProtos.DNGFEntity)cachedTarget), filter, this.relDefaults, true));
            }
            String semanticclass = this.ontologies.inverseOf(relDescriptor);
            String semanticscheme = relDescriptor.getOntologyCode();
            String rd = semanticscheme + "_" + semanticclass;
            this.incrementCounter(rd);
            FieldTypeProtos.DataInfo info = decoder.getDNGF().getDataInfo();
            this.manageInferred(rd, info);
            LinkDescriptor ld = this.entityConfigTable.getDescriptor(relDecoder.getTargetType(), relDescriptor);
            String relId = ld != null && !ld.isSymmetric() ? relDecoder.getRelTargetId() : relDecoder.getRelSourceId();
            rels.add(this.templateFactory.getRel(targetType, relId, metadata, semanticclass, semanticscheme, info.getInferred(), info.getTrust(), info.getInferenceprovenance(), info.getProvenanceaction().getClassid()));
        }
        return rels;
    }

    private List<String> listChildren() {
        ArrayList children = Lists.newArrayList();
        for (DNGFDecoder decoder : this.children) {
            DNGFProtos.DNGFEntity cachedTarget = decoder.getDNGFRel().getCachedTarget();
            this.addChildren(children, cachedTarget, decoder.getRelDescriptor());
        }
        DNGFEntityDecoder entity = this.mainEntity.decodeEntity();
        if (entity.getType().equals((Object)TypeProtos.Type.publication)) {
            for (FieldTypeProtos.Instance instance : ((PublicationProtos.Publication)entity.getEntity()).getInstanceList()) {
                HashSet instanceFieldFilter = Sets.newHashSet((Object[])new String[]{"instancetype", "hostedby", "licence"});
                Function wrExtractor = identifier -> this.templateFactory.getWebResource((String)identifier);
                ArrayList webResources = Lists.newArrayList((Iterable)Iterables.transform((Iterable)instance.getUrlList(), (Function)wrExtractor));
                List<String> instanceFields = this.listFields((GeneratedMessage)instance, instanceFieldFilter, false, false);
                children.add(this.templateFactory.getInstance(instance.getHostedby().getKey(), instanceFields, webResources));
            }
            for (FieldTypeProtos.ExternalReference er : ((PublicationProtos.Publication)entity.getEntity()).getExternalReferenceList()) {
                List<String> fields = this.listFields((GeneratedMessage)er, null, false, false);
                children.add(this.templateFactory.getChild("externalreference", null, fields));
            }
        }
        return children;
    }

    private void addChildren(List<String> children, DNGFProtos.DNGFEntity target, RelDescriptor relDescriptor) {
        DNGFEntityDecoder decoder = DNGFEntityDecoder.decode((DNGFProtos.DNGFEntity)target);
        this.incrementCounter(relDescriptor.getTermCode());
        Set<String> filters = this.entityConfigTable.getFilter(target.getType(), relDescriptor);
        children.add(this.templateFactory.getChild(decoder.getType().toString(), decoder.getId(), this.listFields(decoder.getMetadata(), filters, this.childDefaults, false)));
    }

    private List<String> listFields(GeneratedMessage fields, Set<String> filter, boolean defaults, boolean expandingRel) {
        ArrayList metadata = Lists.newArrayList();
        if (fields != null) {
            HashSet seen = Sets.newHashSet();
            for (Map.Entry<Descriptors.FieldDescriptor, Object> e : this.filterFields(fields, filter)) {
                String name = e.getKey().getName();
                seen.add(name);
                this.addFieldValue(metadata, e.getKey(), e.getValue(), expandingRel);
            }
            if (defaults) {
                for (Descriptors.FieldDescriptor fd : fields.getDescriptorForType().getFields()) {
                    if (seen.contains(fd.getName())) continue;
                    this.addFieldValue(metadata, fd, this.getDefault(fd), expandingRel);
                }
            }
        }
        return metadata;
    }

    private void addFieldValue(List<String> metadata, Descriptors.FieldDescriptor fd, Object value, boolean expandingRel) {
        if ("dateofcollection".equals(fd.getName()) || "dateoftransformation".equals(fd.getName()) || "id".equals(fd.getName()) || value == null) {
            return;
        }
        if (fd.getName().equals("datasourcetype")) {
            String classid = ((FieldTypeProtos.Qualifier)value).getClassid();
            FieldTypeProtos.Qualifier.Builder q = FieldTypeProtos.Qualifier.newBuilder((FieldTypeProtos.Qualifier)((FieldTypeProtos.Qualifier)value));
            if (this.specialDatasourceTypes.contains(classid)) {
                q.setClassid("other").setClassname("other");
            }
            metadata.add(this.asXmlElement("datasourcetypeui", "", q.build(), null));
        }
        if (fd.isRepeated() && value instanceof List) {
            for (Object o : (List)value) {
                this.guessType(metadata, fd, o, expandingRel);
            }
        } else {
            this.guessType(metadata, fd, value, expandingRel);
        }
    }

    private void guessType(List<String> metadata, Descriptors.FieldDescriptor fd, Object o, boolean expandingRel) {
        if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
            StringBuilder sb;
            if (FieldTypeProtos.Qualifier.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.Qualifier qualifier = (FieldTypeProtos.Qualifier)o;
                metadata.add(this.asXmlElement(fd.getName(), "", qualifier, null));
            }
            if (FieldTypeProtos.StructuredProperty.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.StructuredProperty sp = (FieldTypeProtos.StructuredProperty)o;
                metadata.add(this.asXmlElement(fd.getName(), sp.getValue(), sp.getQualifier(), sp.hasDataInfo() ? sp.getDataInfo() : null));
                if (!expandingRel && fd.getName().equals("pid") && sp.getQualifier().getClassid().equalsIgnoreCase("doi")) {
                    this.incrementCounter("doi");
                }
            }
            if (FieldTypeProtos.KeyValue.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.KeyValue kv = (FieldTypeProtos.KeyValue)o;
                metadata.add("<" + fd.getName() + " name=\"" + XmlRecordFactory.escapeXml(kv.getValue()) + "\" id=\"" + XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(kv.getKey())) + "\"/>");
            }
            if (FieldTypeProtos.StringField.getDescriptor().equals(fd.getMessageType())) {
                String fieldName = fd.getName();
                if (fieldName.equals("fundingtree")) {
                    String xmlTree;
                    String string = xmlTree = o instanceof FieldTypeProtos.StringField ? ((FieldTypeProtos.StringField)o).getValue() : o.toString();
                    if (expandingRel) {
                        metadata.add(this.getRelFundingTree(xmlTree));
                        this.fillContextMap(xmlTree);
                    } else {
                        metadata.add(xmlTree);
                    }
                } else {
                    FieldTypeProtos.StringField sf = (FieldTypeProtos.StringField)o;
                    StringBuilder sb2 = new StringBuilder("<" + fd.getName());
                    if (sf.hasDataInfo()) {
                        FieldTypeProtos.DataInfo dataInfo = sf.getDataInfo();
                        this.dataInfoAsAttributes(sb2, dataInfo);
                    }
                    sb2.append(">" + XmlRecordFactory.escapeXml(sf.getValue()) + "</" + fd.getName() + ">");
                    metadata.add(sb2.toString());
                }
            }
            if (FieldTypeProtos.BoolField.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.BoolField bf = (FieldTypeProtos.BoolField)o;
                sb = new StringBuilder("<" + fd.getName());
                if (bf.hasDataInfo()) {
                    FieldTypeProtos.DataInfo dataInfo = bf.getDataInfo();
                    this.dataInfoAsAttributes(sb, dataInfo);
                }
                sb.append(">" + (bf.hasValue() ? Boolean.valueOf(bf.getValue()) : "") + "</" + fd.getName() + ">");
                metadata.add(sb.toString());
            }
            if (FieldTypeProtos.Journal.getDescriptor().equals(fd.getMessageType()) && o != null) {
                FieldTypeProtos.Journal j = (FieldTypeProtos.Journal)o;
                metadata.add("<journal issn=\"" + XmlRecordFactory.escapeXml(j.getIssnPrinted()) + "\" eissn=\"" + XmlRecordFactory.escapeXml(j.getIssnOnline()) + "\" lissn=\"" + XmlRecordFactory.escapeXml(j.getIssnLinking()) + "\">" + XmlRecordFactory.escapeXml(j.getName()) + "</journal>");
            }
            if (FieldTypeProtos.Context.getDescriptor().equals(fd.getMessageType()) && o != null) {
                this.contextes.add(((FieldTypeProtos.Context)o).getId());
            }
            if (FieldTypeProtos.ExtraInfo.getDescriptor().equals(fd.getMessageType()) && o != null) {
                FieldTypeProtos.ExtraInfo e = (FieldTypeProtos.ExtraInfo)o;
                sb = new StringBuilder("<" + fd.getName() + " ");
                sb.append("name=\"" + e.getName() + "\" ");
                sb.append("typology=\"" + e.getTypology() + "\" ");
                sb.append("provenance=\"" + e.getProvenance() + "\" ");
                sb.append("trust=\"" + e.getTrust() + "\"");
                sb.append(">");
                sb.append(e.getValue());
                sb.append("</" + fd.getName() + ">");
                this.extraInfo.add(sb.toString());
            }
            if (WdsDatasetProtos.WdsDataset.GeoLocation.getDescriptor().equals(fd.getMessageType()) && o != null) {
                String geoLocation = XmlFormat.printToString((Message)((WdsDatasetProtos.WdsDataset.GeoLocation)o));
                metadata.add(geoLocation);
            }
        } else if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.ENUM)) {
            if (fd.getFullName().equals("eu.dnetlib.data.proto.DNGFEntity.type")) {
                return;
            }
            metadata.add(this.asXmlElement(fd.getName(), ((Descriptors.EnumValueDescriptor)o).getName(), null, null));
        } else {
            metadata.add(this.asXmlElement(fd.getName(), o.toString(), null, null));
        }
    }

    private StringBuilder dataInfoAsAttributes(StringBuilder sb, FieldTypeProtos.DataInfo dataInfo) {
        sb.append(" inferred=\"" + dataInfo.getInferred() + "\"");
        sb.append(" inferenceprovenance=\"" + dataInfo.getInferenceprovenance() + "\"");
        sb.append(" provenanceaction=\"" + dataInfo.getProvenanceaction().getClassid() + "\"");
        sb.append(" trust=\"" + dataInfo.getTrust() + "\" ");
        return sb;
    }

    private List<String> buildContexts(TypeProtos.Type type) {
        ArrayList res = Lists.newArrayList();
        if (this.contextMapper != null && !this.contextMapper.isEmpty() && type.equals((Object)TypeProtos.Type.publication)) {
            XMLTag document = XMLDoc.newDocument((boolean)true).addRoot("contextRoot");
            for (String context : this.contextes) {
                String id = "";
                for (String token : Splitter.on((String)"::").split((CharSequence)context)) {
                    ContextDef def = (ContextDef)this.contextMapper.get(id = id + token);
                    if (def == null) {
                        throw new IllegalStateException(String.format("cannot find context for id '%s'", id));
                    }
                    if (def.getName().equals("context")) {
                        String xpath = "//context/@id='" + def.getId() + "'";
                        if (!document.gotoRoot().rawXpathBoolean(xpath, new Object[]{new Object()}).booleanValue()) {
                            document = this.addContextDef(document.gotoRoot(), def);
                        }
                    }
                    if (def.getName().equals("category")) {
                        String rootId = StringUtils.substringBefore((String)def.getId(), (String)"::");
                        document = this.addContextDef(document.gotoRoot().gotoTag("//context[./@id='" + rootId + "']", new Object[]{new Object()}), def);
                    }
                    if (def.getName().equals("concept")) {
                        document = this.addContextDef(document, def).gotoParent();
                    }
                    id = id + "::";
                }
            }
            for (Element x : document.gotoRoot().getChildElement()) {
                try {
                    res.add(this.asStringElement(x));
                }
                catch (TransformerException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return res;
    }

    private XMLTag addContextDef(XMLTag tag, ContextDef def) {
        tag.addTag(def.getName()).addAttribute("id", def.getId()).addAttribute("label", def.getLabel());
        if (def.getType() != null && !def.getType().isEmpty()) {
            tag.addAttribute("type", def.getType());
        }
        return tag;
    }

    private String asStringElement(Element element) throws TransformerException {
        StringWriter buffer = new StringWriter();
        this.transformer.transform(new DOMSource(element), new StreamResult(buffer));
        return buffer.toString();
    }

    private String getRelFundingTree(String xmlTree) {
        String funding = "<funding>";
        try {
            Document ftree = new SAXReader().read((Reader)new StringReader(xmlTree));
            funding = "<funding>";
            funding = funding + this.getFunderElement(ftree);
            for (Object o : Lists.reverse((List)ftree.selectNodes("//fundingtree//*[starts-with(local-name(),'funding_level_')]"))) {
                org.dom4j.Element e = (org.dom4j.Element)o;
                String _id = e.valueOf("./id");
                funding = funding + "<" + e.getName() + " name=\"" + XmlRecordFactory.escapeXml(e.valueOf("./name")) + "\">" + XmlRecordFactory.escapeXml(_id) + "</" + e.getName() + ">";
            }
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("unable to parse funding tree: " + xmlTree + "\n" + e.getMessage());
        }
        finally {
            funding = funding + "</funding>";
        }
        return funding;
    }

    private String getFunderElement(Document ftree) {
        String funderId = ftree.valueOf("//fundingtree/funder/id/text()");
        String funderShortName = ftree.valueOf("//fundingtree/funder/shortname/text()");
        String funderName = ftree.valueOf("//fundingtree/funder/name/text()");
        String funderJurisdiction = ftree.valueOf("//fundingtree/funder/jurisdiction/text()");
        return "<funder id=\"" + XmlRecordFactory.escapeXml(funderId) + "\" shortname=\"" + XmlRecordFactory.escapeXml(funderShortName) + "\" name=\"" + XmlRecordFactory.escapeXml(funderName) + "\" jurisdiction=\"" + XmlRecordFactory.escapeXml(funderJurisdiction) + "\" />";
    }

    private void fillContextMap(String xmlTree) {
        Document fundingPath;
        try {
            fundingPath = new SAXReader().read((Reader)new StringReader(xmlTree));
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        try {
            Node funder = fundingPath.selectSingleNode("//funder");
            if (funder != null) {
                String funderShortName = funder.valueOf("./shortname");
                this.contextes.add(funderShortName);
                this.contextMapper.put(funderShortName, new ContextDef(funderShortName, funder.valueOf("./name"), "context", "funding"));
                Node level0 = fundingPath.selectSingleNode("//funding_level_0");
                if (level0 != null) {
                    String level0Id = Joiner.on((String)"::").join((Object)funderShortName, (Object)level0.valueOf("./name"), new Object[0]);
                    this.contextMapper.put(level0Id, new ContextDef(level0Id, level0.valueOf("./description"), "category", ""));
                    Node level1 = fundingPath.selectSingleNode("//funding_level_1");
                    if (level1 == null) {
                        this.contextes.add(level0Id);
                    } else {
                        String level1Id = Joiner.on((String)"::").join((Object)level0Id, (Object)level1.valueOf("./name"), new Object[0]);
                        this.contextMapper.put(level1Id, new ContextDef(level1Id, level1.valueOf("./description"), "concept", ""));
                        Node level2 = fundingPath.selectSingleNode("//funding_level_2");
                        if (level2 == null) {
                            this.contextes.add(level1Id);
                        } else {
                            String level2Id = Joiner.on((String)"::").join((Object)level1Id, (Object)level2.valueOf("./name"), new Object[0]);
                            this.contextMapper.put(level2Id, new ContextDef(level2Id, level2.valueOf("./description"), "concept", ""));
                            this.contextes.add(level2Id);
                        }
                    }
                }
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("malformed funding path: " + xmlTree, e);
        }
    }

    private String asXmlElement(String name, String value, FieldTypeProtos.Qualifier q, FieldTypeProtos.DataInfo dataInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(name);
        if (q != null) {
            sb.append(this.getAttributes(q));
        }
        if (dataInfo != null) {
            sb = this.dataInfoAsAttributes(sb, dataInfo);
        }
        if (value == null || value.isEmpty()) {
            sb.append("/>");
            return sb.toString();
        }
        sb.append(">");
        sb.append(XmlRecordFactory.escapeXml(value));
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }

    private String getAttributes(FieldTypeProtos.Qualifier q) {
        if (q == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : q.getAllFields().entrySet()) {
            sb.append(" ");
            sb.append(((Descriptors.FieldDescriptor)e.getKey()).getName());
            sb.append("=\"");
            sb.append(XmlRecordFactory.escapeXml(e.getValue().toString()));
            sb.append("\"");
        }
        return sb.toString();
    }

    private List<String> countersAsXml() {
        ArrayList out = Lists.newArrayList();
        for (Map.Entry e : this.counters.entrySet()) {
            out.add(String.format("<counter_%s value=\"%s\"/>", e.getKey(), e.getValue()));
        }
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("################################################\n");
        sb.append("ID: ").append(this.key).append("\n");
        if (this.mainEntity != null) {
            sb.append("MAIN ENTITY:\n").append(this.mainEntity.getEntity().toString() + "\n");
        }
        if (this.relations != null) {
            sb.append("\nRELATIONS:\n");
            for (DNGFDecoder decoder : this.relations) {
                sb.append(decoder.getDNGFRel().toString() + "\n");
            }
        }
        if (this.children != null) {
            sb.append("\nCHILDREN:\n");
            for (DNGFDecoder decoder : this.children) {
                sb.append(decoder.getDNGFRel().toString() + "\n");
            }
        }
        return sb.toString();
    }
}

