package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

import java.io.IOException;
import java.util.Set;

import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos.DNGF;
import eu.dnetlib.data.proto.DNGFProtos.DNGFRel;
import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.pace.config.DedupConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.io.Text;

import static eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO.*;


/**
 * Created by claudio on 15/10/15.
 */
public class ConnectedComponentsReducer extends TableReducer<Text, VertexWritable, ImmutableBytesWritable> {

	private static final Log log = LogFactory.getLog(ConnectedComponentsReducer.class);

	private DedupConfig dedupConf;

	private Type type;

	@Override
	protected void setup(final Context context) {

		dedupConf = DedupConfig.load(context.getConfiguration().get(JobParams.DEDUP_CONF));
		log.info("dedup findRoots mapper\nwf conf: " + dedupConf.toString());

		type = Type.valueOf(dedupConf.getWf().getEntityType());
	}

	@Override
	protected void reduce(Text key, Iterable<VertexWritable> values, Context context) throws IOException, InterruptedException {

		final Set<String> set = Sets.newHashSet();

		for(VertexWritable v : values) {
			for(Text t : v.getEdges()) {
				set.add(t.toString());
			}
		}

		final String rootId = newId(key.toString(), dedupConf.getWf().getDedupRun());

		for(final String targetId : set) {

			context.write(ibw(targetId), asPut(buildRel(targetId, rootId, getDedupQualifier_mergedIn(type, rootId))));
			context.write(ibw(rootId), asPut(buildRel(rootId, targetId, getDedupQualifier_merges(type, targetId))));

			context.getCounter(dedupConf.getWf().getEntityType(), "dedupRel (x2)").increment(1);
		}
	}

	private DNGF buildRel(final String from, final String to, final String semantics) {
		final DNGFRel.Builder oafRel = HBaseTableDAO.getDedup(from, to, semantics);
		final DNGF dngf =
				DNGF.newBuilder()
						.setKind(Kind.relation)
						.setLastupdatetimestamp(System.currentTimeMillis())
						.setDataInfo(
								AbstractDNetXsltFunctions.getDataInfo(null, "", "0.8", false, true).setInferenceprovenance(
										dedupConf.getWf().getConfigurationId())).setRel(oafRel)
						.build();
		return dngf;
	}

}
