/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.actions2;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class GarbageActionsMapper
extends TableMapper<ImmutableBytesWritable, Delete> {
    private static final String LATEST_RAW_SETS = "latestRawSets";
    private static final String GARBAGE_TIME_MARING = "garbageTimeMargin";
    private final Set<ByteBuffer> latestRawSets = Sets.newHashSet();
    private long dateLimit;
    private final long MAX_DATE_INTERVAL = 345600000L;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        long garbageTimeMargin = 345600000L;
        try {
            garbageTimeMargin = Long.parseLong(context.getConfiguration().get(GARBAGE_TIME_MARING));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.dateLimit = DateUtils.now() - garbageTimeMargin;
        System.out.println("dateLimit: " + this.dateLimit);
        String s = context.getConfiguration().get(LATEST_RAW_SETS);
        if (s != null) {
            for (String set : Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)s))) {
                this.latestRawSets.add(ByteBuffer.wrap(Bytes.toBytes((String)set)));
            }
        }
        if (this.latestRawSets.isEmpty()) {
            throw new IOException("Input parameter (latestRawSets) is missing or empty: " + s);
        }
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        if (this.isInARecentRawSet(value)) {
            return;
        }
        context.getCounter("Actions", "N. Deletes").increment(1L);
        context.write((Object)key, (Object)new Delete(key.copyBytes()));
    }

    private boolean isInARecentRawSet(Result value) {
        for (byte[] s1 : value.getFamilyMap(Bytes.toBytes((String)"set")).keySet()) {
            if (!this.isRecentRawSet(s1)) continue;
            return true;
        }
        return false;
    }

    private boolean isRecentRawSet(byte[] rawSet) {
        String date = (String)Iterables.getLast((Iterable)Splitter.on((String)"_").split((CharSequence)Bytes.toString((byte[])rawSet)));
        return Long.parseLong(date) > this.dateLimit || this.latestRawSets.contains(ByteBuffer.wrap(rawSet));
    }
}

