/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.actionmanager.actions.AtomicActionSerialiser;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Agent;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.ActionFactory;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AtomicAction;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupSimilarityToHdfsActionsMapper
extends TableMapper<Text, Text> {
    private static final Log log = LogFactory.getLog(DedupSimilarityToHdfsActionsMapper.class);
    private static final String RAW_SET = "rawSetId";
    private static final String SIMILARITY_CF = "similarityCF";
    private String rawSet = null;
    private String similarityCF = null;
    private DedupConfig dedupConf = null;
    private ActionFactory actionFactory = null;
    private Text keyOut;
    private Text valueOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.rawSet = context.getConfiguration().get(RAW_SET);
        if (StringUtils.isBlank((CharSequence)this.rawSet)) {
            throw new IOException("Input parameter (rawSetId) is missing or empty: '" + this.rawSet + "'");
        }
        log.info((Object)("raw set: '" + this.rawSet + "'"));
        this.similarityCF = context.getConfiguration().get(SIMILARITY_CF);
        if (StringUtils.isBlank((CharSequence)this.similarityCF)) {
            throw new IOException("Input parameter (similarityCF) is missing or empty: '" + this.similarityCF + "'");
        }
        log.info((Object)("similarityCF: '" + this.similarityCF + "'"));
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        log.info((Object)("wf conf: " + this.dedupConf.toString()));
        this.actionFactory = new ActionFactory();
        this.keyOut = new Text();
        this.valueOut = new Text();
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        Agent agent = new Agent("dedup", "Deduplication", Agent.AGENT_TYPE.algo);
        HBaseTableDAO.getTargetIds(value, this.similarityCF).forEach(targetId -> {
            String targetKey = new String(key.copyBytes());
            String qualifier = this.similarityCF + ":" + targetId;
            AtomicAction aa = this.actionFactory.createAtomicAction(this.rawSet, agent, targetKey, HBaseTableDAO.cfRels(), qualifier, null);
            this.keyOut.set(aa.getTargetRowKey() + "@" + aa.getTargetColumnFamily() + "@" + aa.getTargetColumn());
            this.valueOut.set(AtomicActionSerialiser.toJSON((AtomicAction)aa));
            try {
                context.write((Object)this.keyOut, (Object)this.valueOut);
                context.getCounter(this.dedupConf.getWf().getEntityType(), "similarity2actions").increment(1L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

