package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.util.Set;

import com.google.gson.Gson;


import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class LinkDescriptor {

	private RelDescriptor relDescriptor;
	private Type target;
	private boolean isChild = false;
	private Set<String> fields;
	private boolean symmetric = true;
	private int max = -1;

	public LinkDescriptor(final RelDescriptor relDescriptor, final Type target, final boolean isChild, final boolean symmetric, final Set<String> fields) {
		super();
		this.setRelDescriptor(relDescriptor);
		this.setTarget(target);
		this.setChild(isChild);
		this.setFields(fields);
		this.setSymmetric(symmetric);
	}

	public LinkDescriptor(final RelDescriptor relDescriptor, final Type target) {
		super();
		this.setRelDescriptor(relDescriptor);
		this.setTarget(target);
	}

	public Type getTarget() {
		return target;
	}

	public void setTarget(final Type target) {
		this.target = target;
	}

    public boolean isChild() {
        return isChild;
    }

	public void setChild(final boolean isChild) {
		this.isChild = isChild;
	}

	public Set<String> getFields() {
		return fields;
	}

	public void setFields(final Set<String> fields) {
		this.fields = fields;
	}

	public boolean isSymmetric() {
		return symmetric;
	}

	public void setSymmetric(final boolean symmetric) {
		this.symmetric = symmetric;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

	public RelDescriptor getRelDescriptor() {
		return relDescriptor;
	}

	public void setRelDescriptor(final RelDescriptor relDescriptor) {
		this.relDescriptor = relDescriptor;
	}

	public int getMax() {
		return max;
	}

	public void setMax(final int max) {
		this.max = max;
	}

}
