package eu.dnetlib.data.mapreduce.hbase.wds;

import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.hbase.dli.kv.DliKey;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.WDSIndexItemProtos;
import eu.dnetlib.dli.proto.ScholixConverter;
import eu.dnetlib.dli.proto.ScholixVersion;
import eu.dnetlib.wds.proto.DNGFWDSIndexConverter;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;

import java.io.IOException;

import static eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO.getMetadata;
import static eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO.rel;

public class IndexWDSMapper extends TableMapper<Text, Text> {

    private Text outKey;

    private Text outValue;

    private static String WDS_COUNTER = "WDS_INDEX";

    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {
        outKey = new Text();
        outValue = new Text();
    }

    @Override
    protected void map(final ImmutableBytesWritable keyIn, final Result value, final Context context) throws IOException, InterruptedException {

        final DNGFWDSIndexConverter converter = new DNGFWDSIndexConverter();
        final DNGFRowKeyDecoder keyDecoder = DNGFRowKeyDecoder.decode(keyIn.copyBytes());
        final TypeProtos.Type type = keyDecoder.getType();
        final DNGFProtos.DNGF entity = getMetadata(value, type);
        if (isValid(entity) && !deletedByInference(entity)) {
            final WDSIndexItemProtos.Item.Builder item = converter.convert(entity);
            rel(value, "isMergedIn", "merges", "isSimilarTo").values().forEach(r -> {
                if (!deletedByInference(r)) {
                    converter.addRelation(item, r.getRel());
                }
            });
            emit(new String(keyIn.copyBytes()), context, JsonFormat.printToString(item.build()));
        }
    }

    private boolean isValid(final DNGFProtos.DNGF entity) {
        return (entity != null) && entity.isInitialized();
    }

    private boolean deletedByInference(final DNGFProtos.DNGF oaf) {
        return oaf.getDataInfo().getDeletedbyinference();
    }

    private void emit(final String key, final Context context, final String data) {
        if (data == null)
            return;
        outKey.set(key);
        outValue.set(data.getBytes());
        try {
            context.write(outKey, outValue);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void incrementCounter(final Context context, final String k, final String t, final int n) {
        getCounter(context, k, t).increment(n);
    }

    private Counter getCounter(final Context context, final String k, final String t) {
        return context.getCounter(k, t);
    }
}
