/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupBuildRootsMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(DedupBuildRootsMapper.class);
    private DedupConfig dedupConf;
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup buildRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType());
        List<String> mergedIn = HBaseTableDAO.getTargetIds(value, "isMergedIn");
        if (mergedIn != null && !mergedIn.isEmpty()) {
            if (mergedIn.size() > 1) {
                throw new RuntimeException("found more than one merged in relation for row key: " + new String(rowkey.copyBytes()));
            }
            Text rootId = new Text(mergedIn.get(0));
            context.getCounter(this.dedupConf.getWf().getEntityType(), "merged").increment(1L);
            DNGFProtos.DNGF dngfMerged = UpdateMerger.mergeBodyUpdates(context, value.getFamilyMap(HBaseTableDAO.cfMetadataByte()), type);
            if (dngfMerged == null) {
                context.getCounter(this.dedupConf.getWf().getEntityType(), "missing body").increment(1L);
                System.out.println("missing body in: " + new String(rowkey.copyBytes()));
                return;
            }
            this.emit(context, rootId, dngfMerged.toByteArray());
            HBaseTableDAO.rel(value, "isMergedIn", "merges", "isSimilarTo").values().forEach(dngf -> {
                if (!this.isRelMarkedDeleted((DNGFProtos.DNGF)dngf)) {
                    this.emit(context, rootId, dngf.toByteArray());
                }
            });
        } else {
            byte[] body;
            List<String> mergesRels = HBaseTableDAO.getTargetIds(value, "merges");
            if (mergesRels != null && !mergesRels.isEmpty() && (body = value.getValue(HBaseTableDAO.cfMetadataByte(), type.toString().getBytes())) != null) {
                context.getCounter(type.toString(), "root").increment(1L);
                this.emit(context, new Text(rowkey.copyBytes()), body);
            }
        }
    }

    private void emit(Mapper.Context context, Text rootId, byte[] value) {
        this.ibw.set(value);
        try {
            context.write((Object)rootId, (Object)this.ibw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isRelMarkedDeleted(DNGFProtos.DNGF dngf) {
        return dngf.getKind().equals((Object)KindProtos.Kind.relation) && dngf.getDataInfo().getDeletedbyinference();
    }
}

