/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.collect.Lists;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.model.DNGFRelDecoder;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.DNGFEntityMerger;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class DedupBuildRootsReducer
extends TableReducer<Text, ImmutableBytesWritable, ImmutableBytesWritable> {
    public static final String FIXED_RELATION = "Fixed Relation";
    private DedupConfig dedupConf;
    private Ontologies ontologies;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup buildRoots reducer\n\nwf conf: " + this.dedupConf.toString());
        this.ontologies = OntologyLoader.loadOntologies((String)context.getConfiguration().get("ontologies"));
        System.out.println("ontologies: " + this.ontologies.toJson(true));
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (!HBaseTableDAO.isRoot(key.toString())) {
            System.err.println("aborting DedupBuildRootsReducer, found non-root key: " + key);
            context.getCounter("DedupBuildRootsReducer", "aborted").increment(1L);
            return;
        }
        byte[] rowkey = Bytes.toBytes((String)key.toString());
        ArrayList entities = Lists.newArrayList();
        for (DNGFProtos.DNGF oaf : this.toDNGF(values)) {
            switch (oaf.getKind()) {
                case entity: {
                    entities.add(oaf);
                    break;
                }
                case relation: {
                    this.handleRels(context, rowkey, oaf, true);
                    break;
                }
            }
        }
        DNGFProtos.DNGF.Builder builder = DNGFEntityMerger.merge((DedupConfig)this.dedupConf, (String)key.toString(), (Iterable)entities);
        if (entities.size() < 20) {
            context.getCounter(this.dedupConf.getWf().getEntityType() + " root group size", this.lpad(entities.size())).increment(1L);
        } else {
            context.getCounter(this.dedupConf.getWf().getEntityType() + " root group size", "> 20").increment(1L);
        }
        DNGFProtos.DNGF dngf = builder.build();
        DNGFProtos.DNGFEntity entity = dngf.getEntity();
        try {
            context.write((Object)new ImmutableBytesWritable(Bytes.toBytes((String)entity.getId())), (Object)HBaseTableDAO.asPut(dngf));
        }
        catch (Throwable e) {
            System.out.println("Exception dngf = " + dngf.toString());
            context.getCounter(entity.getType().toString(), e.getClass().getName()).increment(1L);
        }
        context.getCounter(entity.getType().toString(), "root").increment(1L);
    }

    private Iterable<DNGFProtos.DNGF> toDNGF(Iterable<ImmutableBytesWritable> values) {
        return StreamSupport.stream(values.spliterator(), false).map(ibw -> DNGFDecoder.decode((byte[])ibw.copyBytes()).getDNGF()).collect(Collectors.toList());
    }

    private void handleRels(Reducer.Context context, byte[] rowkey, DNGFProtos.DNGF rel, boolean hack) throws IOException, InterruptedException {
        DNGFDecoder decoder = this.rootToEntity(rowkey, rel, context);
        if ("50|dedup_wf_001::cddddb031b9f6c85046067c0cc9ad147".equals(decoder.getDNGFRel().getSource())) {
            System.out.println(String.format("Writing relation %s    %s     %s ", decoder.getDNGFRel().getSource(), decoder.getDNGFRel().getRelType().getClassname(), decoder.getDNGFRel().getTarget()));
        }
        context.write((Object)new ImmutableBytesWritable(rowkey), (Object)HBaseTableDAO.asPutByCollectedFrom(decoder.getDNGF()));
        decoder = this.entityToRoot(rowkey, rel, context);
        if ("50|dedup_wf_001::cddddb031b9f6c85046067c0cc9ad147".equals(decoder.getDNGFRel().getTarget())) {
            System.out.println(String.format("Writing relation %s    %s     %s ", decoder.getDNGFRel().getSource(), decoder.getDNGFRel().getRelType().getClassname(), decoder.getDNGFRel().getTarget()));
        }
        byte[] revKey = Bytes.toBytes((String)decoder.relSourceId());
        context.write((Object)new ImmutableBytesWritable(revKey), (Object)HBaseTableDAO.asPutByCollectedFrom(decoder.getDNGF()));
        decoder = this.markDeleted(rel, true, context);
        revKey = Bytes.toBytes((String)decoder.relSourceId());
        context.write((Object)new ImmutableBytesWritable(revKey), (Object)HBaseTableDAO.asPut(decoder.getDNGF()));
        decoder = this.markDeleted(rel, false, context);
        revKey = Bytes.toBytes((String)decoder.relSourceId());
        context.write((Object)new ImmutableBytesWritable(revKey), (Object)HBaseTableDAO.asPut(decoder.getDNGF()));
        context.getCounter(FIXED_RELATION, decoder.getRelDescriptor().shortQualifier() + " mark deleted [dup <-> entity]").increment(2L);
    }

    private boolean md5matches(String id1, String id2) {
        return id1.replaceAll("^.*\\:\\:", "").equals(id2.replaceAll("^.*\\:\\:", ""));
    }

    private DNGFDecoder rootToEntity(byte[] rootRowkey, DNGFProtos.DNGF rel, Reducer.Context context) {
        return this.patchRelations(rootRowkey, rel, DNGFPatch.rootToEntity, context);
    }

    private DNGFDecoder entityToRoot(byte[] rootRowkey, DNGFProtos.DNGF rel, Reducer.Context context) {
        return this.patchRelations(rootRowkey, rel, DNGFPatch.entityToRoot, context);
    }

    private DNGFDecoder markDeleted(DNGFProtos.DNGF rel, boolean reverse, Reducer.Context context) {
        return this.deleteRelations(rel, reverse, context);
    }

    private DNGFDecoder patchRelations(byte[] rootRowkey, DNGFProtos.DNGF rel, DNGFPatch patchKind, Reducer.Context context) {
        String id = new String(rootRowkey);
        if ("50|dedup_wf_001::cddddb031b9f6c85046067c0cc9ad147".equals(id)) {
            System.out.println("#########################\n\n");
        }
        DNGFRelDecoder decoder = DNGFRelDecoder.decode((DNGFProtos.DNGFRel)rel.getRel());
        DNGFProtos.DNGF.Builder builder = DNGFProtos.DNGF.newBuilder((DNGFProtos.DNGF)rel);
        builder.getDataInfoBuilder().setInferred(true).setDeletedbyinference(false);
        switch (patchKind) {
            case rootToEntity: {
                builder.getRelBuilder().setSource(new String(rootRowkey));
                break;
            }
            case entityToRoot: {
                builder.setRel(decoder.setClassId(this.getInverse(decoder, context)));
                builder.getRelBuilder().setSource(builder.getRel().getTarget());
                builder.getRelBuilder().setTarget(new String(rootRowkey));
                TypeProtos.Type sourceType = builder.getRelBuilder().getSourceType();
                builder.getRelBuilder().setSourceType(builder.getRel().getTargetType());
                builder.getRelBuilder().setTargetType(sourceType);
                break;
            }
        }
        return DNGFDecoder.decode((DNGFProtos.DNGF)builder.build());
    }

    private String getInverse(DNGFRelDecoder decoder, Reducer.Context context) {
        String inverse = this.ontologies.inverseOf(decoder.getRelDescriptor());
        if (StringUtils.isBlank((CharSequence)inverse)) {
            return "unknown";
        }
        return inverse;
    }

    private DNGFDecoder deleteRelations(DNGFProtos.DNGF rel, boolean reverse, Reducer.Context context) {
        DNGFProtos.DNGF.Builder builder = DNGFProtos.DNGF.newBuilder((DNGFProtos.DNGF)rel);
        builder.getDataInfoBuilder().setDeletedbyinference(true);
        if (reverse) {
            DNGFRelDecoder decoder = DNGFRelDecoder.decode((DNGFProtos.DNGFRel)rel.getRel());
            builder.setRel(decoder.setClassId(this.getInverse(decoder, context)));
            String tmp = builder.getRel().getSource();
            TypeProtos.Type sType = builder.getRel().getSourceType();
            builder.getRelBuilder().setSource(builder.getRel().getTarget());
            builder.getRelBuilder().setTarget(tmp);
            builder.getRelBuilder().setSourceType(builder.getRel().getTargetType());
            builder.getRelBuilder().setTargetType(sType);
        }
        return DNGFDecoder.decode((DNGFProtos.DNGF)builder.build());
    }

    private String lpad(int s) {
        return StringUtils.leftPad((String)String.valueOf(s), (int)5);
    }

    private static enum DNGFPatch {
        rootToEntity,
        entityToRoot;

    }
}

