/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.mapreduce.util.dao.HBaseTableDAO;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.gt.Authors;
import eu.dnetlib.pace.model.gt.CoAuthors;
import eu.dnetlib.pace.model.gt.GTAuthor;
import eu.dnetlib.pace.model.gt.GTAuthorMapper;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;

public class DedupFindRootsPersonReducer
extends TableReducer<ImmutableBytesWritable, ImmutableBytesWritable, ImmutableBytesWritable> {
    private DedupConfig dedupConf;
    private ImmutableBytesWritable outKey;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.outKey = new ImmutableBytesWritable();
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Authors aas = new Authors();
        CoAuthors cas = new CoAuthors();
        for (GTAuthor a : this.asGTA(values)) {
            if (a.hasMerged()) {
                aas.addAll((Collection)a.getMerged());
            } else {
                aas.add((Object)a.getAuthor());
            }
            if (a.hasCoAuthors()) {
                cas.addAll((Collection)a.getCoAuthors());
            }
            byte[] row = Bytes.toBytes((String)a.getId());
            Delete delete = new Delete(row);
            this.outKey.set(row);
            context.write((Object)this.outKey, (Object)delete);
            context.getCounter(this.dedupConf.getWf().getEntityType(), "deleted").increment(1L);
        }
        String rootId = this.hashCodeString(aas);
        GTAuthor gta = new GTAuthor(rootId, aas, cas, true);
        Put put = new Put(Bytes.toBytes((String)gta.getId()));
        put.setWriteToWAL(true);
        put.add(Bytes.toBytes((String)this.dedupConf.getWf().getEntityType()), HBaseTableDAO.cfMetadataByte(), this.toDNGFByteArray(gta));
        this.outKey.set(Bytes.toBytes((String)gta.getId()));
        context.write((Object)this.outKey, (Object)put);
        context.getCounter(this.dedupConf.getWf().getEntityType(), "out").increment(1L);
    }

    private Iterable<GTAuthor> asGTA(Iterable<ImmutableBytesWritable> values) {
        return Iterables.transform(values, input -> GTAuthor.fromJson((String)new String(input.copyBytes())));
    }

    public byte[] toDNGFByteArray(GTAuthor gta) {
        DNGFProtos.DNGF oaf = new GTAuthorMapper().map(gta);
        return oaf.toByteArray();
    }

    protected String hashCodeString(Authors ag) {
        return this.getRowKey(String.valueOf(ag.hashCode()));
    }

    protected String getRowKey(String s) {
        return AbstractDNetXsltFunctions.oafId((String)TypeProtos.Type.person.toString(), (String)"dedup_wf_001", (String)s);
    }
}

