/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.IndexConfig;
import eu.dnetlib.data.mapreduce.util.XmlRecordFactory;
import eu.dnetlib.data.proto.WdsDatasetProtos;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class PrepareFeedReducer
extends Reducer<Text, ImmutableBytesWritable, Text, Text> {
    private static final Log log = LogFactory.getLog(PrepareFeedReducer.class);
    private EntityConfigTable entityConfigTable;
    private ContextMapper contextMapper = new ContextMapper();
    private Ontologies ontologies;
    private String schemaLocation;
    private final boolean entityDefaults = true;
    private final boolean relDefaults = false;
    private final boolean childDefaults = false;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        String json = context.getConfiguration().get("index.entity.links");
        log.info((Object)("index.entity.links:\n" + json));
        this.entityConfigTable = IndexConfig.load(json).getConfigMap();
        this.schemaLocation = context.getConfiguration().get("oaf.schema.location");
        log.info((Object)("schema location:\n" + this.schemaLocation));
        String contextMap = context.getConfiguration().get("contextmap");
        log.info((Object)("contextmap:\n" + contextMap));
        try {
            this.contextMapper = ContextMapper.fromXml(contextMap);
            log.info((Object)("context map:\n" + this.contextMapper));
        }
        catch (DocumentException e) {
            throw new RuntimeException("unable to parse contextMap: " + contextMap, e);
        }
        this.ontologies = OntologyLoader.loadOntologies((String)context.getConfiguration().get("ontologies"));
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        DNGFRowKeyDecoder keyDecoder = DNGFRowKeyDecoder.decode((String)key.toString());
        try {
            XmlRecordFactory builder = new XmlRecordFactory(this.entityConfigTable, this.contextMapper, this.ontologies, this.schemaLocation, true, false, false);
            try {
                this.decodeValues(keyDecoder, values, builder);
                if (builder.isValid()) {
                    context.write((Object)new Text(keyDecoder.getKey()), (Object)new Text(builder.build()));
                } else {
                    context.getCounter("missing body (reduce)", keyDecoder.getType().toString()).increment(1L);
                }
            }
            catch (OutOfMemoryError e) {
                context.getCounter("error", e.getClass().getName()).increment(1L);
                log.error((Object)String.format("memory error building entity\nid: '%s'\ncounters: %s", keyDecoder.getKey(), builder.getRelCounters()), (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private void decodeValues(DNGFRowKeyDecoder keyDecoder, Iterable<ImmutableBytesWritable> values, XmlRecordFactory builder) {
        block4: for (ImmutableBytesWritable bytes : values) {
            DNGFDecoder decoder = DNGFDecoder.decode((byte[])bytes.copyBytes(), (GeneratedMessage.GeneratedExtension[])new GeneratedMessage.GeneratedExtension[]{WdsDatasetProtos.WdsDataset.geolocation});
            switch (decoder.getKind()) {
                case entity: {
                    builder.setMainEntity(decoder);
                    continue block4;
                }
                case relation: {
                    if (decoder.getDNGFRel().getChild()) {
                        builder.addChild(keyDecoder.getType(), decoder);
                        continue block4;
                    }
                    builder.addRelation(keyDecoder.getType(), decoder);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("unknow type: " + decoder.getKind());
        }
    }
}

