/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util.dao;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.graph.model.DNGFRelDecoder;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DliFieldTypeProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.WDSFieldTypeProtos;
import eu.dnetlib.data.proto.WdsDatasetProtos;
import eu.dnetlib.data.proto.WdsPublicationProtos;
import eu.dnetlib.data.transform.Ontologies;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseTableDAO {
    public static final String ROOT = "dedup_wf";

    public static byte[] cfMetadataByte() {
        return Bytes.toBytes((String)HBaseTableDAO.cfMetadata());
    }

    public static String cfMetadata() {
        return ColumnFamily.metadata.toString();
    }

    public static byte[] cfRelsByte() {
        return Bytes.toBytes((String)HBaseTableDAO.cfRels());
    }

    public static String cfRels() {
        return ColumnFamily.rels.toString();
    }

    public static RelDescriptor parseQualifier(byte[] qualifier) {
        return HBaseTableDAO.parseQualifier(new String(qualifier));
    }

    private static RelDescriptor parseQualifier(String qualifier) {
        return new RelDescriptor(qualifier);
    }

    public static String newId(String id, String dedupRun) {
        if (dedupRun == null || dedupRun.length() != 3) {
            throw new IllegalArgumentException("wrong dedupRun param");
        }
        return id.replaceFirst("\\|.*\\:\\:", HBaseTableDAO.dedupPrefix(dedupRun));
    }

    public static byte[] newIdBytes(String s, String dedupRun) {
        return HBaseTableDAO.newId(s, dedupRun).getBytes();
    }

    public static byte[] newIdBytes(ByteBuffer b, String dedupRun) {
        return HBaseTableDAO.newId(new String(b.array()), dedupRun).getBytes();
    }

    public static String dedupPrefix(String dedupRun) {
        return "|dedup_wf_" + dedupRun + "::";
    }

    public static boolean isRoot(String s) {
        return s.contains(ROOT);
    }

    public static DNGFProtos.DNGFRel.Builder getDedup(String from, String to, String relQualifier) {
        RelDescriptor rd = new RelDescriptor(relQualifier);
        DNGFProtos.DNGFRel.Builder rel = DNGFProtos.DNGFRel.newBuilder().setRelType(FieldTypeProtos.Qualifier.newBuilder().setClassid(rd.getTermCode()).setClassname(rd.getTermCode()).setSchemeid(rd.getOntologyCode()).setSchemename(rd.getOntologyCode())).setSource(from).setSourceType(DNGFRowKeyDecoder.decode((String)from).getType()).setTarget(to).setTargetType(DNGFRowKeyDecoder.decode((String)to).getType()).setChild(false);
        return rel;
    }

    public static boolean isRoot(ImmutableBytesWritable s) {
        return HBaseTableDAO.isRoot(s.copyBytes());
    }

    public static boolean isRoot(byte[] s) {
        return HBaseTableDAO.isRoot(new String(s));
    }

    public static String getDedupQualifier_merges(TypeProtos.Type type, String targetId) {
        return HBaseTableDAO.getDedupQualifier_merges(type) + ":" + targetId;
    }

    public static byte[] getDedupQualifier_mergesBytes(TypeProtos.Type type, String targetId) {
        return Bytes.toBytes((String)HBaseTableDAO.getDedupQualifier_merges(type, targetId));
    }

    public static String getDedupQualifier_merges(TypeProtos.Type type) {
        return HBaseTableDAO.getDedupRelType(type) + "_" + "merges";
    }

    public static String getDedupQualifier_mergedIn(TypeProtos.Type type) {
        return HBaseTableDAO.getDedupRelType(type) + "_" + "isMergedIn";
    }

    public static String getDedupQualifier_mergedIn(TypeProtos.Type type, String targetId) {
        return HBaseTableDAO.getDedupQualifier_mergedIn(type) + ":" + targetId;
    }

    public static String getDedupQualifier_merges(String type) {
        return HBaseTableDAO.getDedupQualifier_merges(TypeProtos.Type.valueOf((String)type));
    }

    public static byte[] getDedupQualifier_mergesBytes(TypeProtos.Type type) {
        return Bytes.toBytes((String)HBaseTableDAO.getDedupQualifier_merges(type));
    }

    public static byte[] getDedupQualifier_mergesBytes(String type) {
        return HBaseTableDAO.getDedupQualifier_mergesBytes(TypeProtos.Type.valueOf((String)type));
    }

    public static byte[] getDedupQualifier_mergesBytes(String type, String targetId) {
        return HBaseTableDAO.getDedupQualifier_mergesBytes(TypeProtos.Type.valueOf((String)type), targetId);
    }

    public static String getDedupQualifier_mergedIn(String type) {
        return HBaseTableDAO.getDedupQualifier_mergedIn(TypeProtos.Type.valueOf((String)type));
    }

    public static byte[] getDedupQualifier_mergedInBytes(TypeProtos.Type type) {
        return Bytes.toBytes((String)HBaseTableDAO.getDedupQualifier_mergedIn(type));
    }

    public static byte[] getDedupQualifier_mergedInBytes(TypeProtos.Type type, String targetId) {
        return Bytes.toBytes((String)HBaseTableDAO.getDedupQualifier_mergedIn(type, targetId));
    }

    public static byte[] getDedupQualifier_mergedInBytes(String type) {
        return HBaseTableDAO.getDedupQualifier_mergedInBytes(TypeProtos.Type.valueOf((String)type));
    }

    public static String getSimilarityQualifier(TypeProtos.Type type) {
        return HBaseTableDAO.getDedupRelType(type) + "_" + "isSimilarTo";
    }

    public static String getSimilarityQualifier(TypeProtos.Type type, String targetId) {
        return HBaseTableDAO.getSimilarityQualifier(type) + ":" + targetId;
    }

    public static String getSimilarityQualifier(String type) {
        return HBaseTableDAO.getSimilarityQualifier(TypeProtos.Type.valueOf((String)type));
    }

    public static byte[] getSimilarityQualifierBytes(TypeProtos.Type type) {
        return Bytes.toBytes((String)HBaseTableDAO.getSimilarityQualifier(type));
    }

    public static byte[] getSimilarityQualifierBytes(TypeProtos.Type type, String targetId) {
        return Bytes.toBytes((String)HBaseTableDAO.getSimilarityQualifier(type, targetId));
    }

    public static String getInverseRelation(DNGFProtos.DNGF.Builder inputRel, Ontologies ontologies) {
        return HBaseTableDAO.getInverseRelation(DNGFRelDecoder.decode((DNGFProtos.DNGFRel)inputRel.getRel()).getRelDescriptor(), ontologies);
    }

    public static String getInverseRelation(RelDescriptor inputRel, Ontologies ontologies) {
        try {
            String inverseRelation = ontologies.inverseOf(inputRel);
            if (StringUtils.isBlank((CharSequence)inverseRelation)) {
                return "unknown";
            }
            return inverseRelation;
        }
        catch (Throwable e) {
            return "unknown";
        }
    }

    public static byte[] getSimilarityQualifierBytes(String type) {
        return HBaseTableDAO.getSimilarityQualifierBytes(TypeProtos.Type.valueOf((String)type));
    }

    public static String getRelTypeString(TypeProtos.Type type) {
        return HBaseTableDAO.getDedupRelType(type).toString();
    }

    public static List<String> getTargetIds(Result result, String qualifier) {
        NavigableMap rels = result.getFamilyMap(HBaseTableDAO.cfRelsByte());
        if (rels == null) {
            return new ArrayList<String>();
        }
        return HBaseTableDAO.getTargetIds(rels, qualifier);
    }

    public static List<String> getTargetIds(Map<byte[], byte[]> rels, String semantics) {
        return rels.keySet().stream().map(String::new).filter(s -> s.contains(semantics)).map(s -> StringUtils.substringAfter((String)s, (String)":")).collect(Collectors.toList());
    }

    public static byte[] getMetadataB(Result value, TypeProtos.Type type) {
        return value.getValue(HBaseTableDAO.cfMetadataByte(), Bytes.toBytes((String)type.toString()));
    }

    public static DNGFProtos.DNGF getMetadata(Result value, TypeProtos.Type type) throws InvalidProtocolBufferException {
        byte[] body = HBaseTableDAO.getMetadataB(value, type);
        return body != null ? HBaseTableDAO.parseProto(body) : null;
    }

    public static String getDedupRelType(TypeProtos.Type type) {
        switch (type) {
            case organization: {
                return "organization_organization";
            }
            case person: {
                return "person_person";
            }
            case publication: {
                return "publication_publication";
            }
            case dataset: {
                return "dataset_dataset";
            }
            case unknown: {
                return "unknown_unknown";
            }
        }
        throw new IllegalArgumentException("Deduplication not supported for entity type: " + type);
    }

    public static Put asPutByCollectedFrom(DNGFProtos.DNGF dngf) {
        switch (dngf.getKind()) {
            case entity: {
                return HBaseTableDAO.asPut(dngf, HBaseTableDAO.sumHashes(dngf.getEntity().getCollectedfromList()).longValue());
            }
            case relation: {
                return HBaseTableDAO.asPut(dngf, HBaseTableDAO.sumHashes(dngf.getRel().getCollectedfromList()).longValue());
            }
        }
        throw new IllegalArgumentException("invalid kind");
    }

    private static Integer sumHashes(List<FieldTypeProtos.KeyValue> cfs) {
        return cfs.stream().map(FieldTypeProtos.KeyValue::getValue).map(String::hashCode).map(Math::abs).mapToInt(Integer::intValue).sum();
    }

    public static Put asPut(DNGFProtos.DNGF dngf, Long ts) {
        switch (dngf.getKind()) {
            case entity: {
                Put entity = HBaseTableDAO.getPut(dngf.getEntity().getId(), ts);
                return entity.add(HBaseTableDAO.cfMetadataByte(), Bytes.toBytes((String)dngf.getEntity().getType().toString()), dngf.toByteArray());
            }
            case relation: {
                DNGFProtos.DNGFRel rel = dngf.getRel();
                Put putRel = HBaseTableDAO.getPut(rel.getSource(), ts);
                FieldTypeProtos.Qualifier relType = rel.getRelType();
                String qualifier = relType.getSchemeid() + "_" + relType.getClassid() + ":" + rel.getTarget();
                return putRel.add(HBaseTableDAO.cfRelsByte(), Bytes.toBytes((String)qualifier), dngf.toByteArray());
            }
        }
        throw new IllegalArgumentException("invalid kind");
    }

    private static Put getPut(String rowkey, Long ts) {
        Put put = ts != null ? new Put(Bytes.toBytes((String)rowkey), ts.longValue()) : new Put(Bytes.toBytes((String)rowkey));
        put.setWriteToWAL(true);
        return put;
    }

    public static Put asPut(DNGFProtos.DNGF dngf) {
        return HBaseTableDAO.asPut(dngf, null);
    }

    public static byte[] rowKey(DNGFProtos.DNGF dngf) {
        switch (dngf.getKind()) {
            case entity: {
                return dngf.getEntity().getId().getBytes();
            }
            case relation: {
                DNGFProtos.DNGFRel rel = dngf.getRel();
                return rel.getSource().getBytes();
            }
        }
        throw new IllegalArgumentException("invalid kind");
    }

    public static Map<String, Map<Long, DNGFProtos.DNGF>> relVersions(Result value, String ... filter) {
        NavigableMap map = (NavigableMap)value.getMap().get(HBaseTableDAO.cfRelsByte());
        return HBaseTableDAO.filterMapKeys(map, filter).collect(Collectors.toMap(key -> key, key -> ((NavigableMap)map.get(key.getBytes())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, inner -> HBaseTableDAO.parseProto((byte[])inner.getValue())))));
    }

    public static Map<String, DNGFProtos.DNGF> rel(Result value, String ... filter) {
        NavigableMap map = value.getFamilyMap(HBaseTableDAO.cfRelsByte());
        return HBaseTableDAO.filterMapKeys(map, filter).collect(Collectors.toMap(key -> key, key -> HBaseTableDAO.parseProto((byte[])map.get(key.getBytes()))));
    }

    private static Stream<String> filterMapKeys(Map<byte[], ?> map, String ... filter) {
        return map.keySet().stream().map(Bytes::toString).filter(HBaseTableDAO.asFilter(filter));
    }

    private static Predicate<String> asFilter(String ... filters) {
        return qualifier -> Arrays.asList(filters).stream().allMatch(filter -> !qualifier.contains((CharSequence)filter));
    }

    public static DNGFProtos.DNGF parseProto(byte[] value) {
        DNGFDecoder d = DNGFDecoder.decode((byte[])value, (GeneratedMessage.GeneratedExtension[])new GeneratedMessage.GeneratedExtension[]{DliFieldTypeProtos.completionStatus, DliProtos.completionStatus, DliProtos.resolvedfrom, DliProtos.typedIdentifier, WdsDatasetProtos.WdsDataset.geolocation, WdsDatasetProtos.WdsDataset.otherRels, WdsPublicationProtos.WdsPublication.projects, WdsDatasetProtos.WdsDataset.projects, WDSFieldTypeProtos.identifierType, WDSFieldTypeProtos.identifierValue, WDSFieldTypeProtos.relationSemantic});
        return d.getDNGF();
    }

    public static Function<DNGFDecoder, String> idDecoder() {
        return input -> input.getEntityId();
    }

    public static ImmutableBytesWritable ibw(String targetId) {
        return new ImmutableBytesWritable(Bytes.toBytes((String)targetId));
    }

    public static enum ColumnFamily {
        metadata,
        rels;

    }
}

