package eu.dnetlib.functionality.modular.ui.vocabularies.persistence;

import java.util.List;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Term;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Vocabulary;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class VocabularyDAO {

	@Autowired
	protected UniqueServiceLocator serviceLocator;

	public abstract List<Vocabulary> getVocabularies() throws VocabularyException;

	public abstract List<Term> getTerms(final String vocabularyId) throws VocabularyException;

	public abstract void commitTerms(final List<Term> terms, final String vocabularyId) throws VocabularyException;

	public abstract void commitVocabularyInfo(final Vocabulary voc, final String vocabularyId) throws VocabularyException;

	public abstract String createVocabulary(final Vocabulary voc) throws VocabularyException;

	public abstract void dropVocabulary(final String vocabularyId) throws VocabularyException;

}
