/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.is;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscriptionRegistry;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.is.bulk.ProfileImporter;
import eu.dnetlib.functionality.modular.ui.is.objects.BlackboardMessage;
import eu.dnetlib.functionality.modular.ui.is.objects.CollectionDesc;
import eu.dnetlib.functionality.modular.ui.is.objects.ServiceDesc;
import eu.dnetlib.functionality.modular.ui.is.objects.ServiceGrouperDesc;
import eu.dnetlib.functionality.modular.ui.is.objects.SubscriptionDesc;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class InformationServiceInternalController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(InformationServiceInternalController.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Resource(name="modularUiProfileImporter")
    private ProfileImporter profileImporter;
    @Resource(name="issResourceStateNotificationRegistries")
    private transient List<ResourceStateSubscriptionRegistry> registries;

    @RequestMapping(value={"/ui/is/xquery.do"})
    @ResponseBody
    public List<String> query(@RequestParam(value="query", required=true) String query) throws Exception {
        log.debug((Object)("Executing xquery: " + query));
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query);
    }

    @RequestMapping(value={"/ui/is/listSchemas.do"})
    @ResponseBody
    public List<String> listSchemas() throws Exception {
        List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).listResourceTypes();
        Collections.sort(list);
        return list;
    }

    @RequestMapping(value={"/ui/is/getSchema.do"})
    @ResponseBody
    public String getSchema(@RequestParam(value="name", required=true) String name) throws Exception {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceTypeSchema(name);
    }

    @RequestMapping(value={"/ui/is/listCollections.do"})
    @ResponseBody
    public List<CollectionDesc> listCollections() throws Exception {
        String xquery = "for $kind in xmldb:get-child-collections('/db/DRIVER') for $type in xmldb:get-child-collections(concat('/db/DRIVER/', $kind)) return concat ($kind, ' @@@ ', $type, ' @@@ ', count(xmldb:get-child-resources(concat('/db/DRIVER/', $kind, '/', $type))))";
        HashMap map = Maps.newHashMap();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $kind in xmldb:get-child-collections('/db/DRIVER') for $type in xmldb:get-child-collections(concat('/db/DRIVER/', $kind)) return concat ($kind, ' @@@ ', $type, ' @@@ ', count(xmldb:get-child-resources(concat('/db/DRIVER/', $kind, '/', $type))))")) {
            String[] arr = s.split("@@@");
            String kind = arr[0].trim();
            String type = arr[1].trim();
            int size = NumberUtils.toInt((String)arr[2].trim(), (int)0);
            if (!map.containsKey(kind)) {
                map.put(kind, new CollectionDesc(kind));
            }
            ((CollectionDesc)map.get(kind)).addType(type, size);
        }
        ArrayList res = Lists.newArrayList(map.values());
        for (CollectionDesc d : res) {
            Collections.sort(d.getTypes());
        }
        Collections.sort(res);
        return res;
    }

    @RequestMapping(value={"/ui/is/listProfiles.do"})
    @ResponseBody
    public List<String> listProfiles(@RequestParam(value="kind", required=true) String kind, @RequestParam(value="type", required=true) String type) throws Exception {
        String collName = "/db/DRIVER/" + kind + "/" + type;
        String xquery = "distinct-values(for $x in collection('" + collName + "') return $x//RESOURCE_IDENTIFIER/@value/string())";
        List res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
        Collections.sort(res);
        return res;
    }

    @RequestMapping(value={"/ui/is/getProfile.do"})
    @ResponseBody
    public String getProfiles(@RequestParam(value="id", required=true) String id) throws Exception {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(id);
    }

    @RequestMapping(value={"/ui/is/registerProfile.do"})
    @ResponseBody
    public String registerProfile(@RequestParam(value="profile", required=true) String profile) throws Exception {
        return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).registerProfile(profile);
    }

    @RequestMapping(value={"/ui/is/updateProfile.do"})
    @ResponseBody
    public String updateProfile(@RequestParam(value="profile", required=true) String profile) throws Exception {
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(profile));
        String id = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
        String type = doc.valueOf("//RESOURCE_TYPE/@value");
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new Exception("RESOURCE_IDENTIFIER is empty");
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new Exception("RESOURCE_TYPE is empty");
        }
        if (((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(id, profile, type)) {
            return id;
        }
        throw new Exception("Profile not updated");
    }

    @RequestMapping(value={"/ui/is/deleteProfile.do"})
    @ResponseBody
    public boolean deleteProfile(@RequestParam(value="id", required=true) String id) throws Exception {
        return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).deleteProfile(id);
    }

    @RequestMapping(value={"/ui/is/import.do"})
    @ResponseBody
    public Map<String, Integer> importProfiles(@RequestParam(value="path", required=true) String path, @RequestParam(value="profiles", required=true) boolean profiles, @RequestParam(value="schemas", required=true) boolean schemas) throws Exception {
        log.info((Object)("importing profiles/schemas from " + path));
        HashMap res = Maps.newHashMap();
        if (schemas) {
            res.putAll(this.profileImporter.importSchemas(path + "/**/*.xsd"));
        }
        if (profiles) {
            res.putAll(this.profileImporter.importProfiles(path + "/**/*.xml"));
        }
        return res;
    }

    @RequestMapping(value={"/ui/is/listBlackboards.do"})
    @ResponseBody
    public List<BlackboardMessage> listBlackboards() throws Exception {
        ArrayList list = Lists.newArrayList();
        SAXReader reader = new SAXReader();
        for (String xml : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/ServiceResources')//MESSAGE return <message>{$x/../../..//RESOURCE_TYPE}{$x/../../..//RESOURCE_IDENTIFIER}{$x}</message>")) {
            BlackboardMessage info = new BlackboardMessage();
            Document doc = reader.read((Reader)new StringReader(xml));
            info.setProfId(doc.valueOf(".//RESOURCE_IDENTIFIER/@value"));
            info.setMessageId(doc.valueOf(".//@id"));
            info.setResourceType(doc.valueOf(".//RESOURCE_TYPE/@value"));
            info.setAction(doc.valueOf(".//ACTION"));
            info.setDate(doc.valueOf(".//@date"));
            info.setActionStatus(doc.valueOf(".//ACTION_STATUS"));
            info.setError(doc.valueOf(".//PARAMETER[@name='error']/@value"));
            list.add(info);
        }
        return list;
    }

    @RequestMapping(value={"/ui/is/getMetaWfIdForFamily.do"})
    @ResponseBody
    public Map<String, String> getMetaWfId(@RequestParam(value="family", required=true) String family) throws ISLookUpException {
        String xq = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where $x//METAWORKFLOW_NAME/@family='" + family + "' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//METAWORKFLOW_SECTION)";
        HashMap map = Maps.newHashMap();
        try {
            String[] arr = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xq).split("@@@");
            map.put("id", arr[0].trim());
            map.put("section", arr[1].trim());
        }
        catch (ISLookUpDocumentNotFoundException e) {
            map.put("id", "");
            map.put("section", "");
        }
        map.put("family", family);
        return map;
    }

    @RequestMapping(value={"/ui/is/listServices.do"})
    @ResponseBody
    public Collection<ServiceGrouperDesc> listServices() throws Exception {
        String xq = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/functionality/modular/xquery/listServices.xquery"));
        ArrayList list = Lists.newArrayList();
        SAXReader reader = new SAXReader();
        for (Object s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xq)) {
            Document doc = reader.read((Reader)new StringReader((String)s));
            String id = doc.valueOf("/service/id").trim();
            String name = doc.valueOf("/service/name").trim();
            String wsdl = doc.valueOf("/service/wsdl").trim();
            list.add(new ServiceDesc(id, name, wsdl));
        }
        XPathFactory xpathFactory = XPathFactory.newInstance();
        for (ResourceStateSubscriptionRegistry registry : this.registries) {
            for (ResourceStateSubscription sub : registry.getSubscriptionDao().listSubscriptions()) {
                boolean notFound = true;
                DOMResult result = new DOMResult();
                sub.getSubscriberAsEpr().writeTo((Result)result);
                String wsdl = xpathFactory.newXPath().evaluate("//*[local-name() = 'Address']", result.getNode()) + "?wsdl";
                for (ServiceDesc s : list) {
                    if (!s.getWsdl().equalsIgnoreCase(wsdl)) continue;
                    s.getSubscriptions().add(new SubscriptionDesc(sub));
                    notFound = false;
                }
                if (!notFound) continue;
                ServiceDesc desc = new ServiceDesc("", "", wsdl);
                desc.getSubscriptions().add(new SubscriptionDesc(sub));
                desc.setStatus(ServiceDesc.ServiceStatus.MISSING);
                list.add(desc);
            }
        }
        HashMap map = Maps.newHashMap();
        for (ServiceDesc s : list) {
            URL url = new URL(s.getWsdl());
            String host = url.getHost();
            int port = url.getPort();
            String context = (String)Iterables.getFirst((Iterable)Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)url.getPath()), (Object)"");
            String tmpKey = host + "@@@" + port + "@@@" + context;
            if (!map.containsKey(tmpKey)) {
                map.put(tmpKey, new ServiceGrouperDesc(host, port, context, new ArrayList<ServiceDesc>()));
            }
            ((ServiceGrouperDesc)map.get(tmpKey)).getServices().add(s);
        }
        return map.values();
    }

    @RequestMapping(value={"/ui/is/ping.do"})
    @ResponseBody
    public long pingUrl(@RequestParam(value="url", required=true) String url, @RequestParam(value="timeout", required=true) int timeout) throws IOException {
        long start = DateUtils.now();
        HttpURLConnection urlConn = (HttpURLConnection)new URL(url).openConnection();
        urlConn.setConnectTimeout(timeout);
        urlConn.setReadTimeout(timeout);
        if (urlConn.getResponseCode() == 200) {
            return DateUtils.now() - start;
        }
        throw new IllegalArgumentException("Invalid Url");
    }

    public void sendXML(ServletResponse response, String xml) throws IOException {
        response.setContentType("text/xml");
        ServletOutputStream out = response.getOutputStream();
        IOUtils.copy((Reader)new StringReader(xml), (OutputStream)out);
        out.flush();
        out.close();
    }
}

