/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.oai;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.functionality.modular.ui.oai.IndexPath;
import eu.dnetlib.functionality.modular.ui.oai.OAIIndex;
import eu.dnetlib.functionality.modular.ui.oai.TDSRule;
import eu.dnetlib.oai.PublisherField;
import eu.dnetlib.oai.conf.OAIConfigurationExistReader;
import eu.dnetlib.oai.conf.OAIConfigurationWriter;
import eu.dnetlib.oai.info.SetInfo;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.utils.MetadataReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OAIInternalController {
    private static final Log log = LogFactory.getLog(OAIInternalController.class);
    @Autowired
    private OAIConfigurationExistReader configuration;
    @Autowired
    private OAIConfigurationWriter configurationWriter;

    @RequestMapping(value={"/ui/getExportMDFs.do"})
    public void getExportMDFs(HttpServletResponse response) throws Exception {
        List exportMDFs = this.configuration.getMetadataFormatInfo();
        String json = new Gson().toJson((Object)exportMDFs);
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/getSourceMDFs.do"})
    @ResponseBody
    public List<MetadataReference> getSourceMDFs(HttpServletResponse response) throws Exception {
        return this.configuration.getMetadataFormatInfo().stream().map(mdf -> mdf.getSourceMetadataReference()).distinct().collect(Collectors.toList());
    }

    @RequestMapping(value={"/ui/getSetSpecs.do"})
    @ResponseBody
    public List<String> getSetSpecs(HttpServletResponse response) throws Exception {
        return this.configuration.getSetSpecs();
    }

    @RequestMapping(value={"/ui/getMetadataFormat.do"})
    @ResponseBody
    public MDFInfo getMetadataFormat(HttpServletResponse response, @RequestParam(value="mdPrefix", required=true) String mdPrefix) throws Exception {
        return this.configuration.getMetadataFormatInfo(mdPrefix);
    }

    @RequestMapping(value={"/ui/saveMetadataFormat.do"}, method={RequestMethod.POST})
    public void saveMetadataFormat(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="mdPrefix", required=true) String mdPrefix) throws Exception {
        MDFInfo update = (MDFInfo)new Gson().fromJson((Reader)request.getReader(), MDFInfo.class);
        if (update.getBaseQuery() == null) {
            update.setBaseQuery("");
        }
        if (update.getTransformationRuleID() == null) {
            update.setTransformationRuleID("");
        }
        log.debug((Object)("Update to object" + update));
        boolean result = false;
        if (this.configuration.getMetadataFormatInfo(mdPrefix) != null) {
            log.debug((Object)("UPDATING mdPrefix = " + mdPrefix));
            result = this.configurationWriter.updateMetadataFormat(mdPrefix, update);
        } else {
            log.debug((Object)("CREATING new mdPrefix = " + mdPrefix));
            result = this.configurationWriter.addMetadataFormat(update);
        }
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/deleteMetadataFormat.do"})
    public void deleteMetadataFormat(HttpServletResponse response, @RequestParam(value="mdPrefix", required=true) String mdPrefix) throws Exception {
        boolean result = this.configurationWriter.deleteMetadataFormat(mdPrefix);
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/showSetDetails.do"})
    public void showSetDetails(HttpServletResponse response, @RequestParam(value="setSpec", required=true) String setSpec) throws Exception {
        SetInfo set = this.configuration.getSetInfo(setSpec);
        String json = new Gson().toJson((Object)set);
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/saveOAISet.do"}, method={RequestMethod.POST})
    public void saveOAISet(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="setSpec", required=true) String setSpec) throws Exception {
        log.debug((Object)("setSpec = " + setSpec));
        SetInfo update = (SetInfo)new Gson().fromJson((Reader)request.getReader(), SetInfo.class);
        log.debug((Object)("Update to object" + update));
        boolean result = false;
        if (this.configuration.getSetInfo(setSpec) != null) {
            log.debug((Object)("UPDATING set = " + setSpec));
            result = this.configurationWriter.updateOAISet(setSpec, update);
        } else {
            log.debug((Object)("CREATING new OAIset = " + setSpec));
            result = this.configurationWriter.addOAISet(update);
        }
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/deleteOAISet.do"})
    public void deleteOAISet(HttpServletResponse response, @RequestParam(value="setSpec", required=true) String setSpec) throws Exception {
        boolean result = this.configurationWriter.deleteOAISet(setSpec);
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/showIndices.do"})
    public void showIndices(HttpServletResponse response, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation) throws Exception {
        List fields = this.configuration.getFields(format, interpretation, layout);
        ArrayList indices = Lists.newArrayList();
        for (PublisherField field : fields) {
            Collection paths = field.getSources().get((Object)(format + "-" + layout + "-" + interpretation));
            ArrayList pathList = Lists.newArrayList();
            for (String p : paths) {
                pathList.add(new IndexPath(p));
            }
            if (pathList.size() <= 0) continue;
            OAIIndex idx = new OAIIndex();
            idx.setRepeatable(field.isRepeatable());
            idx.setName(field.getFieldName());
            idx.setPaths(pathList);
            indices.add(idx);
        }
        String json = new Gson().toJson((Object)indices);
        log.debug((Object)("The map of indices: " + json));
        IOUtils.copy((Reader)new StringReader(json), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/saveIndices.do"}, method={RequestMethod.POST})
    public void saveIndices(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation) throws Exception {
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)request.getInputStream(), (Writer)sw);
        Type collectionType = new TypeToken<List<OAIIndex>>(){}.getType();
        List indexes = (List)new Gson().fromJson(sw.toString(), collectionType);
        String mdformatKey = format + "-" + layout + "-" + interpretation;
        List updatedIndices = indexes.stream().map(oaiIndex -> {
            PublisherField f = new PublisherField();
            f.setFieldName(oaiIndex.getName());
            f.setRepeatable(oaiIndex.isRepeatable());
            ArrayListMultimap paths = ArrayListMultimap.create();
            for (IndexPath path : oaiIndex.getPaths()) {
                paths.put((Object)mdformatKey, (Object)path.getPath());
            }
            f.setSources((Multimap)paths);
            return f;
        }).collect(Collectors.toList());
        log.debug((Object)("Updating indices" + indexes));
        boolean result = this.configurationWriter.updateIndices(format, layout, interpretation, updatedIndices);
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/saveNewIndex.do"})
    public void saveNewIndex(HttpServletResponse response, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation, @RequestParam(value="indexName", required=true) String indexName, @RequestParam(value="repeatable", required=true) boolean repeatable, @RequestParam(value="paths", required=true) String paths) throws Exception {
        String[] thePaths = paths.split(",");
        boolean result = this.configurationWriter.addNewIndex(format, layout, interpretation, indexName, repeatable, thePaths);
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/saveNewPathIndex.do"})
    public void saveNewPathIndex(HttpServletResponse response, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation, @RequestParam(value="indexName", required=true) String indexName, @RequestParam(value="newPath", required=true) String newPath) throws Exception {
        List fields = this.configurationWriter.getConfiguration().getFields(format, interpretation, layout).stream().map(field -> {
            if (field.getFieldName().equals(indexName)) {
                field.getSources().get((Object)(format + "-" + layout + "-" + interpretation)).add(newPath);
            }
            return field;
        }).collect(Collectors.toList());
        boolean result = this.configurationWriter.updateIndices(format, layout, interpretation, fields);
        response.getWriter().print(result);
    }

    @RequestMapping(value={"/ui/getTransformationRules.do"})
    @ResponseBody
    public List<TDSRule> getTransformationRules(HttpServletResponse response) throws IOException, ISLookUpException {
        String query = "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') return concat('id:-:',$x//RESOURCE_IDENTIFIER/@value/string(), ':-:title:-:', $x//CONFIGURATION//TITLE)";
        return this.configuration.getLookupClient().search("for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') return concat('id:-:',$x//RESOURCE_IDENTIFIER/@value/string(), ':-:title:-:', $x//CONFIGURATION//TITLE)", TDSRule.class, ":-:");
    }
}

