/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories.controllers;

import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.repositories.util.RepoUIUtils;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.msro.workflows.procs.WorkflowExecutor;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.ProtocolParameterValue;
import eu.dnetlib.rmi.datasource.BrowseTerm;
import eu.dnetlib.rmi.datasource.DatasourceDesc;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import eu.dnetlib.rmi.datasource.DatasourceManagerServiceException;
import eu.dnetlib.rmi.datasource.IfaceDesc;
import eu.dnetlib.rmi.datasource.RepositoryMapEntry;
import eu.dnetlib.rmi.datasource.SearchInterfacesEntry;
import eu.dnetlib.rmi.datasource.SimpleDatasourceDesc;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RepoInternalController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(RepoInternalController.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private WorkflowSectionGrouper workflowSectionGrouper;
    @Autowired
    private WorkflowExecutor workflowExecutor;
    @Autowired
    private RepoUIUtils repoUIUtils;
    @Resource(name="repoUIJsonCache")
    private Cache repoUIJsonCache;

    @RequestMapping(value={"/ui/browseRepoField.do"})
    @ResponseBody
    public List<BrowseTerm> browseRepoField(@RequestParam(value="field", required=true) String field) throws Exception {
        return ((DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class)).browseField(field);
    }

    @RequestMapping(value={"/ui/listApis.do"})
    @ResponseBody
    public List<SearchInterfacesEntry> listApis(@RequestParam(value="param", required=true) String param, @RequestParam(value="value", required=true) String value, @RequestParam(value="refresh", required=false) String refresh) throws Exception {
        String cacheKey = "list@@@" + param + "@@@" + value;
        Element elem = this.repoUIJsonCache.get((Serializable)((Object)cacheKey));
        if (elem != null && refresh == null) {
            return (List)elem.getObjectValue();
        }
        log.info((Object)("Refreshing " + cacheKey + " cache..."));
        List list = ((DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class)).searchInterface(param, value);
        this.repoUIJsonCache.put(new Element((Object)cacheKey, (Object)list));
        return list;
    }

    @RequestMapping(value={"/ui/listRepositories.map"})
    @ResponseBody
    public List<RepositoryMapEntry> listRepositories_asMap() throws Exception {
        return ((DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class)).getRepositoryMap();
    }

    @RequestMapping(value={"/ui/listRepositories.json"})
    @ResponseBody
    public List<SimpleDatasourceDesc> listRepositories(@RequestParam(value="type", required=true) String type) throws Exception {
        return ((DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class)).simpleListDatasourcesByType(type);
    }

    @RequestMapping(value={"/ui/repo/repoApi.update"})
    @ResponseBody
    public boolean updateRepoApi(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="accessParams", required=true) String accessParamsJson) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)accessParamsJson)) {
            ((DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class)).bulkUpdateApiAccessParams(repoId, ifaceId, (Map)new Gson().fromJson(accessParamsJson, Map.class));
        }
        return true;
    }

    @RequestMapping(value={"/ui/repo/repoApiCompliance.update"})
    @ResponseBody
    public boolean updateRepoApiCompliance(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="compliance", required=true) String compliance) throws Exception {
        log.debug((Object)("SET COMPLIANCE TO " + compliance));
        ((DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class)).overrideCompliance(repoId, ifaceId, compliance);
        this.repoUIJsonCache.removeAll();
        return true;
    }

    @RequestMapping(value={"/ui/repo/repoApiCompliance.reset"})
    @ResponseBody
    public boolean resetRepoApiCompliance(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId) throws Exception {
        log.debug((Object)"RESET COMPLIANCE");
        ((DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class)).overrideCompliance(repoId, ifaceId, null);
        this.repoUIJsonCache.removeAll();
        return true;
    }

    @RequestMapping(value={"/ui/repoApi.new"})
    @ResponseBody
    public boolean addRepoApi(@RequestParam(value="repoId", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceJson) throws DatasourceManagerServiceException {
        IfaceDesc iface = (IfaceDesc)new Gson().fromJson(ifaceJson, IfaceDesc.class);
        log.info((Object)("Adding interface " + iface.getId() + " to repository " + repoId));
        DatasourceManagerService dsManager = (DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class);
        return dsManager.addInterface(repoId, iface);
    }

    @RequestMapping(value={"/ui/repo.new"})
    @ResponseBody
    public boolean addRepoApi(@RequestParam(value="repo", required=true) String repoJson) throws DatasourceManagerServiceException {
        DatasourceDesc ds = (DatasourceDesc)new Gson().fromJson(repoJson, DatasourceDesc.class);
        ds.setDateOfCollection(new Date());
        if (StringUtils.isBlank((CharSequence)ds.getEnglishName())) {
            ds.setEnglishName(ds.getOfficialName());
        }
        log.info((Object)("Adding datasource " + ds.getId() + " - name " + ds.getOfficialName()));
        DatasourceManagerService dsManager = (DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class);
        return dsManager.addDatasource(ds);
    }

    @RequestMapping(value={"/ui/listValidValuesForParam.do"})
    @ResponseBody
    public List<ProtocolParameterValue> listValidValuesForParam(@RequestParam(value="protocol", required=true) String protocol, @RequestParam(value="param", required=true) String param, @RequestParam(value="baseUrl", required=true) String baseUrl) throws CollectorServiceException {
        return ((CollectorService)this.serviceLocator.getService(CollectorService.class)).listValidValuesForParam(protocol, baseUrl, param, null);
    }
}

