/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.objects.sections;

import com.google.common.collect.Sets;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowItem;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowSectionGrouper {
    private static final long CACHE_DURATION = 600000L;
    private Set<String> cache = Sets.newHashSet();
    private long cacheDate = 0L;
    @Autowired
    private ISLookupClient isLookupClient;

    public List<WorkflowItem> listWorflowsForDatasource(String dsId) {
        return this.isLookupClient.listWorflowsForDatasource(dsId);
    }

    public List<WorkflowItem> listWorflowsForSection(String name) {
        return this.isLookupClient.listWorflowsForSection(name);
    }

    public String getDatasourceName(String dsId) {
        return this.isLookupClient.getDatasourceName(dsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllSectionNames() {
        Set<String> set = this.cache;
        synchronized (set) {
            if (this.cache.isEmpty() || DateUtils.now() - this.cacheDate > 600000L) {
                this.cache.clear();
                this.cache.addAll(this.isLookupClient.listSimpleWorflowSections());
                this.cacheDate = DateUtils.now();
            }
        }
        HashSet res = Sets.newHashSet(this.cache);
        res.remove("datasources");
        return res;
    }
}

