/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.values;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.ProtocolParameterValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ListProtocolFieldValues
extends ValidNodeValuesFetcher {
    private static final Log log = LogFactory.getLog(ListProtocolFieldValues.class);
    private final ExecutorService pool = Executors.newFixedThreadPool(10);
    @Autowired
    private UniqueServiceLocator serviceLocator;

    protected List<ValidNodeValuesFetcher.DnetParamValue> obtainValues(Map<String, String> params) throws Exception {
        this.verifyParams(params, new String[]{"baseUrl", "protocol", "field"});
        final String protocol = params.get("protocol");
        final String baseUrl = params.get("baseUrl");
        final String field = params.get("field");
        Future<List<ValidNodeValuesFetcher.DnetParamValue>> futureList = this.pool.submit(new Callable<List<ValidNodeValuesFetcher.DnetParamValue>>(){

            @Override
            public List<ValidNodeValuesFetcher.DnetParamValue> call() throws Exception {
                List list = ((CollectorService)ListProtocolFieldValues.this.getServiceLocator().getService(CollectorService.class)).listValidValuesForParam(protocol, baseUrl, field, null);
                return Lists.newArrayList((Iterable)Lists.transform((List)list, (Function)new Function<ProtocolParameterValue, ValidNodeValuesFetcher.DnetParamValue>(){

                    public ValidNodeValuesFetcher.DnetParamValue apply(ProtocolParameterValue ppv) {
                        return new ValidNodeValuesFetcher.DnetParamValue((ValidNodeValuesFetcher)ListProtocolFieldValues.this, ppv.getId(), ppv.getName());
                    }
                }));
            }
        });
        try {
            return futureList.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error((Object)("Error obtaining values of protocol: " + protocol));
            futureList.cancel(true);
            return new ArrayList<ValidNodeValuesFetcher.DnetParamValue>();
        }
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

