var module = angular.module('oaiUI', []);

function oaiCtrl($scope, $http) {

	common_init($scope, $http);

	$scope.loadTransformationRules = function () {
		$http.get('getTransformationRules.do')
			.success(
				function (data) {
					$scope.tdsRules = data;
				}
			)
			.error(
				function () {
					show_notification('error', 'Cannot load info about transformation rules');
				}
			);
	}

	$scope.equals = function (s1, s2) {
		return s1 == s2;
	}

	//EXPORT METADATA FORMAT//

	$scope.showExportMetadataFormat = function (mdFormat) {
		showSpinner();
		$scope.show = 'mdformat';
		$scope.currentMdf = mdFormat;
		$scope.currentPrefix = mdFormat.prefix;
		$scope.loadTransformationRules();
		hideSpinner();
	}

	$scope.loadExportMetadataFormat = function (mdPrefix) {
		showSpinner();
		$http.get('getMetadataFormat.do?mdPrefix=' + mdPrefix)
			.success(
				function (data) {
					$scope.currentMdf = data;
					$scope.currentPrefix = mdPrefix;
				}
			)
			.error(
				function () {
					show_notification('error', 'Cannot load info about export metadata format ' + mdPrefix);
				}
			);
		$scope.loadTransformationRules();
		hideSpinner();
	}

	$scope.saveExportMetadataFormat = function (mdPrefix, mdf, isNew) {
		$('.modal').modal('hide');
		showSpinner();
		$http.post('saveMetadataFormat.do?mdPrefix=' + mdPrefix, mdf)
			.success(
				function (data) {
					if (data) {
						var newSourceMdf = mdf.sourceMetadataReference;
						if (isNew) {
							$scope.exportFormats.push(mdf);
							if (!contains($scope.srcFormats, newSourceMdf)) $scope.srcFormats.push(newSourceMdf);
							show_notification('success', "Metadata format successfully added");
						}
						else {
							//did we updated the mdprefix? We have to remove the old mdPrefix!
							if (mdPrefix != mdf.prefix) {
								removeFromList($scope.exportFormats, $scope.currentMdf);
							}
							//did we updated the source? We have to add the new source, if it is not there yet
							if (!contains($scope.srcFormats, newSourceMdf)) $scope.srcFormats.push(newSourceMdf);

							upsertExportFormat($scope.exportFormats, mdf, mdPrefix);
							show_notification('success', "Metadata format successfully updated");
						}
					}
					else show_notification('error', 'Cannot update mdformat ' + mdPrefix);
				}
			).error(
			function () {
				show_notification('error', 'Cannot update mdformat ' + mdPrefix);
			}
		);
		hideSpinner();
	}

	$scope.deleteExportMetadataFormat = function (mdPrefix) {
		showSpinner();
		$http.post('deleteMetadataFormat.do?mdPrefix=' + mdPrefix)
			.success(
				function (data) {
					if (data) {
						show_notification('success', "Metadata format successfully removed");
						removeFromList($scope.exportFormats, $scope.currentMdf);
						$scope.show = '';
						$scope.currentMdf = '';
						$scope.currentPrefix = '';
					}
					else show_notification('error', 'Cannot delete mdformat ' + mdPrefix);

				}
			).error(
			function () {
				show_notification('error', 'Cannot delete mdformat ' + mdPrefix);
			}
		);
		hideSpinner();
	}

	//SOURCE METADATA FORMATS and INDEXES//

	$scope.showSrcMetadataFormat = function (mdFormat) {
		showSpinner();
		$scope.show = 'source';
		$scope.currentMdf = mdFormat
		$scope.currentPrefix = mdFormat.format
		$scope.showStoreIndexes($scope.currentMdf.format, $scope.currentMdf.layout, $scope.currentMdf.interpretation);
		hideSpinner();
	}

	$scope.saveIndexes = function (sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, indices) {
		showSpinner();
		$http.post('saveIndices.do?format=' + sourceFormatName + '&layout=' + sourceFormatLayout + '&interpretation=' + sourceFormatInterpretation, indices)
			.success(
				function (data) {
					if (data) show_notification('success', "Indexes successfully updated");
					else show_notification('error', 'Cannot update indices for metadata format ' + sourceFormatName);
					hideSpinner();
				}
			).error(
			function () {
				hideSpinner();
				show_notification('error', 'Cannot update indexes ');
			}
		);
	}

	$scope.saveNewIndex = function (sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, index) {
		$('.modal').modal('hide');
		showSpinner();
		$http.post('saveNewIndex.do?format=' + sourceFormatName + '&layout=' + sourceFormatLayout + '&interpretation=' + sourceFormatInterpretation + '&indexName=' + index.name + '&paths=' + index.paths + '&repeatable=' + index.repeatable)
			.success(
				function (data) {
					if (data) {
						show_notification('success', "index successfully created");
					}
					else show_notification('error', 'Cannot create index for metadata format ' + sourceFormatName);

				}
			).error(
			function () {

				show_notification('error', 'Cannot create index on mdf ' + sourceFormatName + " - " + sourceFormatLayout + " - " + sourceFormatInterpretation);
			}
		);
		hideSpinner();
	}

	$scope.saveNewPathIndex = function (sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, indexName, newPath) {
		$('.modal').modal('hide');
		showSpinner();
		$http.post('saveNewPathIndex.do?format=' + sourceFormatName + '&layout=' + sourceFormatLayout + '&interpretation=' + sourceFormatInterpretation + '&indexName=' + indexName + '&newPath=' + newPath)
			.success(
				function (data) {
					if (data) {
						show_notification('success', "Path successfully added");
					}
					else show_notification('error', 'Cannot add path to index ' + indexName);

				}
			).error(
			function () {

				show_notification('error', 'Cannot add path to index ' + indexName);
			}
		);
		hideSpinner();
	}

	$scope.showStoreIndexes = function (sourceFormatName, sourceFormatLayout, sourceFormatInterpretation) {
		showSpinner();
		$http.get('showIndices.do?format=' + sourceFormatName + '&layout=' + sourceFormatLayout + '&interpretation=' + sourceFormatInterpretation)
			.success(
				function (data) {
					$scope.indices = data;
				}
			)
			.error(
				function () {
					show_notification('error', 'Cannot show info about indices of metadata format=' + sourceFormatName + ' layout=' + sourceFormatLayout + ' interpretation=' + sourceFormatInterpretation);
				}
			);
		hideSpinner();
	}


	$scope.deleteIndexPath = function (indexPathList, indexPath) {
		removeFromList(indexPathList, indexPath);
	}

	//OAI SETS//

	$scope.showOAISet = function (setSpec) {
		showSpinner();
		$scope.show = 'set';
		$http.get('showSetDetails.do?setSpec=' + setSpec)
			.success(
				function (data) {
					$scope.currentSet = data;
					$scope.currentSetSpec = setSpec;
				}
			).error(
			function () {
				show_notification('error', 'Cannot show info about OAI set ' + setSpec);
			}
		);
		hideSpinner();
	}

	$scope.deleteOAISet = function (setSpec) {
		showSpinner();
		$http.post('deleteOAISet.do?setSpec=' + setSpec)
			.success(
				function (data) {
					if (data) {
						removeFromList($scope.setSpecs, setSpec);
						$scope.show = '';
						$scope.currentSetSpec = '';
						$scope.currentSet = '';
						show_notification('success', "OAI set successfully removed");
					}
					else show_notification('error', 'Cannot delete OAI set ' + setSpec);
				}
			).error(
			function () {
				show_notification('error', 'Cannot delete OAI set ' + setSpec);
			}
		);
		hideSpinner();
	}

	$scope.saveOAISet = function (setSpec, set) {
		$('.modal').modal('hide');
		showSpinner();
		$http.post('saveOAISet.do?setSpec=' + setSpec, set)
			.success(
				function (data) {
					if (data) {
						show_notification('success', "OAI set configuration successfully updated");
						//did we updated the setSpec?
						if (setSpec != set.setSpec) {
							$scope.setSpecs.push(set.setSpec);
							removeFromList($scope.setSpecs, setSpec);
						}
						else {
							//add it: we created a new set!
							if (!contains($scope.setSpecs, set.setSpec)) $scope.setSpecs.push(set.setSpec)
						}

					}
					else show_notification('error', 'Cannot update configuration for OAI set ' + setSpec);
					$scope.showOAISet(set.setSpec);
				}
			).error(
			function () {
				show_notification('error', 'Cannot update OAI Set ' + setSpec);
			}
		);
		hideSpinner();
	}

	/*---------ADD NEW MDPREFIX--------*/
	$scope.showMDFModal = function () {
		$scope.modalMdf = '';
		$('#mdfModal').modal();
	}

	/*---------ADD NEW SET--------*/
	$scope.showSetModal = function () {
		$scope.modalMdf = '';
		$('#setModal').modal();
	}

	/*---------ADD NEW INDEX--------*/
	$scope.showIndexModal = function () {
		$scope.modalIndex = {'repeatable': false};
		$('#indexModal').modal();
	}

	/*---------ADD NEW INDEX PATH--------*/
	$scope.showNewPathModal = function (oaiIndex) {
		$scope.newPath = '';
		$scope.modalIndex = oaiIndex;
		$('#indexPathModal').modal();
	}
}