var module = angular.module('uniqueChecker', []);

module.directive('uniqueTerm', function() {
    return {
      restrict: 'A',
      require: 'ngModel',
      link: function (scope, element, attrs, ngModel) {
	            function validateTerm() {
	            	ngModel.$setValidity('unique', true);
	            	if (!scope.modalTerm.englishName || (scope.selectedTermIndex != -1 && scope.modalTerm.englishName.toLowerCase() == scope.entries[scope.selectedTermIndex].englishName.toLowerCase())) {
	            		return;
	            	}
	            	for (i in scope.entries) {
	            		if (scope.entries[i].englishName.toLowerCase() == scope.modalTerm.englishName.toLowerCase()) {
	            			ngModel.$setValidity('unique', false);
	            			return;
	            		}
	            		for (j in scope.entries[i].synonyms) {
	            			if (scope.entries[i].synonyms[j].term.toLowerCase() == scope.modalTerm.englishName.toLowerCase()) {
		            			ngModel.$setValidity('unique', false);
		            			return;
		            		}
	            		}
	            	}
	            }
	            
	            // register callback (validate) for $scope.modalTerm.englishName
	            scope.$watch( 
	        		function() {
	        			return scope.modalTerm.englishName;
	        		}, validateTerm);
	        }
    };
});

module.directive('uniqueCode', function() {
  return {
    restrict: 'A',
    require: 'ngModel',
    link: function (scope, element, attrs, ngModel) {
	          function validateCode() {
		          	ngModel.$setValidity('unique', true);
		          	if (!scope.modalTerm.code || (scope.selectedTermIndex != -1 && scope.modalTerm.code.toLowerCase() == scope.entries[scope.selectedTermIndex].code.toLowerCase())) {
		          		return;
		          	}
		          	for (i in scope.entries) {
		          		if (scope.modalTerm.code.toLowerCase() == scope.entries[i].code.toLowerCase()) {
		          			ngModel.$setValidity('unique', false);
		          		}
		          	}
	          	}
	
	          // register callback (validate) for $scope.modalTerm.code
	          scope.$watch( 
	          		function() {
	          			return scope.modalTerm.code;
	          		}, validateCode);
	      	}
  };
});

module.directive('uniqueSynonym', function() {
  return {
    restrict: 'A',
    require: 'ngModel',
    link: function (scope, element, attrs, ngModel) {
	    	  function validateSynonym() {
	    		  ngModel.$setValidity('unique', true);
	          		if (!scope.modalSynonym.term || (scope.selectedSynonymIndex != -1 && scope.modalSynonym.term.toLowerCase() == scope.entries[scope.selectedTermIndex].synonyms[scope.selectedSynonymIndex].term.toLowerCase())) {
	          			return;
	          		}
	          		for (i in scope.entries) {
		          		for (j in scope.entries[i].synonyms) {
		          			if (scope.entries[i].synonyms[j].term.toLowerCase() == scope.modalSynonym.term.toLowerCase()) {
		            			ngModel.$setValidity('unique', false);
		            			return;
		            		}
		          		}
	          		}
	          	}
	          
	          	// register callback (validate) for $scope.modalTerm.englishName
	          	scope.$watch( 
		      		function() {
		      			return scope.modalSynonym.term;
		      		}, validateSynonym);
	      }
  };
});