/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.util;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowNotificationInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowUpdateInfo;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class ISRegistryClient {
    private static final Log log = LogFactory.getLog(ISRegistryClient.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public String registerProfile(String profile) throws ISRegistryException {
        return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).registerProfile(profile);
    }

    public void deleteProfile(String id) throws ISRegistryException {
        ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).deleteProfile(id);
    }

    public boolean updateWorkflowProfile(String wfId, String profile, Map<String, String> map) throws Exception {
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        for (Map.Entry<String, String> e : map.entrySet()) {
            String val;
            Node node = doc.selectSingleNode("//CONFIGURATION/PARAMETERS/PARAM[@name='" + e.getKey() + "']");
            if (node == null) {
                log.error((Object)("Param " + e.getKey() + " not found in profile " + profile));
                continue;
            }
            String string = val = e.getValue() != null ? e.getValue() : "";
            if (node.valueOf("@managedBy").equalsIgnoreCase("user")) {
                node.setText(val);
                continue;
            }
            log.debug((Object)("Param " + e.getKey() + " not updated, it is not editable by user"));
        }
        if (doc.selectNodes("//CONFIGURATION/PARAMETERS/PARAM[@required='true' and string-length(normalize-space(.)) = 0]").isEmpty()) {
            ((Element)doc.selectSingleNode("//CONFIGURATION")).addAttribute("status", WorkflowsConstants.WorkflowStatus.EXECUTABLE.name());
        } else {
            ((Element)doc.selectSingleNode("//CONFIGURATION")).addAttribute("status", WorkflowsConstants.WorkflowStatus.WAIT_USER_SETTINGS.name());
        }
        return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(wfId, doc.asXML(), doc.valueOf("//RESOURCE_TYPE/@value"));
    }

    public boolean updateWorkflowProfile(String wfId, String profile, WorkflowUpdateInfo info) throws Exception {
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        doc.selectSingleNode("//CONFIGURATION/@start").setText(info.getMode().toString());
        Element notificationsNode = (Element)doc.selectSingleNode("//NOTIFICATIONS");
        notificationsNode.clearContent();
        if (info.getNotifications() != null) {
            for (WorkflowNotificationInfo n : info.getNotifications()) {
                Element emailNode = notificationsNode.addElement("EMAIL");
                emailNode.addAttribute("address", n.getEmail());
                emailNode.addAttribute("messageProfileId", n.getMessageProfileId());
                emailNode.addAttribute("condition", n.getCondition().toString());
            }
        }
        doc.selectSingleNode("//WORKFLOW_PRIORITY").setText(Integer.toString(info.getPriority()));
        Node node = doc.selectSingleNode("//SCHEDULING");
        ((Element)node).addAttribute("enabled", Boolean.toString(info.isScheduled()));
        if (info.isScheduled()) {
            node.selectSingleNode("./CRON").setText(info.getCron() != null ? info.getCron() : "");
            node.selectSingleNode("./MININTERVAL").setText(Integer.toString(info.getInterval()));
        }
        return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfile(wfId, doc.asXML(), doc.valueOf("//RESOURCE_TYPE/@value"));
    }

    public void updateWorkflowStatus(String id, WorkflowsConstants.WorkflowStatus status) throws ISRegistryException {
        ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(id, "//CONFIGURATION/@status", "'" + status.toString() + "'");
    }
}

