var cronMaker = angular.module("cronMaker", []);

cronMaker.filter('range', function() {
	return function(input, min, max) {
		min = parseInt(min); //Make string input int
		max = parseInt(max);
		for (var i=min; i<=max; i++) {
			input.push(i);
		}
		return input;
	};
});

cronMaker.directive("cronMakerModal", function () {
	return {
		restrict: 'E',
		transclude: true,
		replace:true,
		scope: {
	        'cronExpression'  : '=',
	        'visible'         : '='
		},
		templateUrl: '../resources/html/wf/cron-maker-modal.html',
		
		link: function (scope, element, attrs, ctrl) {
			scope.p1 = '0'; // Seconds      (0-59)
			scope.p2 = '0'; // Minutes      (0-59)
			scope.p3 = '0'; // Hours        (0-23)
			scope.p4 = '1'; // Day of Month (1-31)
			scope.p5 = '1'; // Month        (1-12 or JAN-DEC)
			scope.p6 = '1'; // Day of week  (1-7 or SUN-SAT)
			
			scope.error = '';
			
			$(element).modal({'show': false});
		
			scope.$watch(function() {
				return scope.visible;
			}, function(value) {
				if (value == true) { 
					$(element).modal('show');
					$('#cronMakerTabs a:first').tab('show')
					scope.visible = false;
					scope.prepareForCronMinutes();
				}
			});
						
			scope.verifyPart = function(name, val, min, max) {
				if (!val || val.length == 0) {
					scope.error = '[' + name + '] is empty';
					return false;
				}
				if (val == '?' || val == '*') {
					return true;
				}
				if (/^(0|1)\/\d+$/.test(val)) {
					return true;
				}
				if (Number.isInteger(val)) {
					if (val >= min && val <= max) {
						return true;
					} else {
						scope.error = '[' + name + '] is out of range (value: ' + val + ', range: ' + min + '-' + max + ')';
						return false;
					}
				}
				
				if (/^\d+$/.test(val)) {
					if (parseInt(val) >= min && parseInt(val) <= max) {
						return true;
					} else {
						scope.error = '[' + name + '] is out of range (value: ' + val + ', range: ' + min + '-' + max + ')';
						return false;
					}
				}
				
				scope.error = '[' + name + '] is invalid (value: ' + val + ')';
				
				return false;
			};
			
			scope.verifyDaysPart = function(name, val) {
				if (!val || val.length == 0) {
					scope.error = '[' + name + '] is empty';
					return false;
				}
				if (val == '?' || val == '*') {
					return true;
				}
				
				var res = true;
				angular.forEach(val.split(','), function(d) {
					if (!((d == 'MON') || (d == 'TUE') || (d == 'WED') || (d == 'THU') || (d == 'FRI') || (d == 'SAT') || (d == 'SUN'))) {
						scope.error = '[' + name + '] has an invalid day: ' + d;
						res = false;
					}
				});
				
				return res;
			}

			scope.isValid = function() {
				scope.error = '';
				return (
					(scope.verifyPart("Seconds",      scope.p1, 0, 59)) &&
					(scope.verifyPart("Minutes",      scope.p2, 0, 59)) &&
					(scope.verifyPart("Hours",        scope.p3, 0, 23)) &&
					(scope.verifyPart("Day of Month", scope.p4, 1, 31)) &&
					(scope.verifyPart("Month",        scope.p5, 1, 12)) &&
					(scope.verifyDaysPart("Day of week", scope.p6))
				);
			}
			
			scope.updateCronExpression = function () {
				scope.cronExpression = scope.p1 + ' ' + scope.p2 + ' '  + scope.p3 + ' ' + scope.p4 + ' ' + scope.p5 + ' ' + scope.p6;
			};
			
			scope.updateCronPart = function(part, value) {
				scope[part] = value;
			};
			
			scope.prepareForCronMinutes = function () {
				scope.stepMinutes = 10;
				
				scope.p1 = '0';
				scope.p2 = '0/' + scope.stepMinutes;
				scope.p3 = '*';
				scope.p4 = '1/1';
				scope.p5 = '*';
				scope.p6 = '?';
			};		
			
			scope.prepareForCronHour = function () {
				scope.stepHour = 1;
				
				scope.p1 = '0';
				scope.p2 = '0';
				scope.p3 = '0/' + scope.stepHour;
				scope.p4 = '1/1';
				scope.p5 = '*';
				scope.p6 = '?';
			};

			scope.prepareForCronDay = function () {
				scope.stepDay = 1;
				scope.atHour = 12;				
				scope.atMinute = 30;				
				
				scope.p1 = '0';
				scope.p2 = scope.atMinute;
				scope.p3 = scope.atHour;
				scope.p4 = '1/' + scope.stepDay;
				scope.p5 = '*';
				scope.p6 = '?';
			};
			
			scope.prepareForCronWeek = function () {
				scope.days = {
					'MON' : true,
					'TUE' : true,
					'WED' : true,
					'THU' : true,
					'FRI' : true,
					'SAT' : false,
					'SUN' : false
				};

				scope.atHour = 12;				
				scope.atMinute = 30;				
				
				scope.p1 = '0';
				scope.p2 = scope.atMinute;
				scope.p3 = scope.atHour;
				scope.p4 = '?';
				scope.p5 = '*';
				scope.p6 = scope.getSelectedDays(scope.days);
			};

			scope.getSelectedDays = function(map) {
				var res = [];
				angular.forEach(map, function(v, k) {
					if (v) res.push(k);
				});
				return res.join(',');
			}
			
			scope.prepareForCronMonth = function () {
				scope.stepMonth = 1;
				
				scope.atDay = 1;
				scope.atHour = 12;				
				scope.atMinute = 30;				
				
				scope.p1 = '0';
				scope.p2 = scope.atMinute;
				scope.p3 = scope.atHour;
				scope.p4 = scope.atDay;
				scope.p5 = '1/' + scope.stepMonth;
				scope.p6 = '?';
			};
			
			scope.prepareForCronYear = function () {
				scope.atDay = 25;
				scope.atMonth = '2';
				scope.atHour = 9;				
				scope.atMinute = 15;				
				
				scope.p1 = '0';
				scope.p2 = scope.atMinute;
				scope.p3 = scope.atHour;
				scope.p4 = scope.atDay;
				scope.p5 = scope.atMonth;
				scope.p6 = '?';
			};
		}
	}
});
