<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				version="1.0">

	<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" standalone="no"/>

	<xsl:template match="/">

		<xsl:variable name="id" select="//RESOURCE_IDENTIFIER/@value"/>
		<xsl:variable name="name" select="//WORKFLOW_NAME"/>
		<xsl:variable name="startMode" select="//CONFIGURATION/@start"/>
		<xsl:variable name="status" select="//CONFIGURATION/@status"/>

		<xsl:variable name="interval" select="//SCHEDULING/MININTERVAL"/>

		<div class="row">
  			
  			<wf-graph-modal wf-id="currentGraphId" visible="showGraphModal" />
  			<wf-process-modal proc-id="currentProcId" visible="showProcModal" />
  			
  			<xsl:for-each select="//DATASOURCE">
				<repo-access-params-modal ds-id="{@id}" iface="{@interface}" protocol="{@protocol}" visible="showAccessParamsModal" />
  			</xsl:for-each>
  
			<div class="col-xs-12 col-md-4 col-lg-2">
				<ul class="nav  nav-pills nav-stacked">
					<li class="active" style="cursor: pointer">
						<a data-target="#tabInfo" data-toggle="tab" ng-click="refresh()">Workflow Info</a>
					</li>
					<li style="cursor: pointer">
						<a data-target="#tabParameters" data-toggle="tab">Parameters</a>
					</li>
					<li style="cursor: pointer">
						<a data-target="#tabHistory" data-toggle="tab" ng-click="updateHistory('{$id}')">History</a>
					</li>
					<li style="cursor: pointer">
						<a data-target="#tabSettings" data-toggle="tab">Other settings</a>
					</li>
				</ul>
			</div>
			<div class="col-xs-12 col-md-8 col-lg-10">
				<h5>
					<b>Workflow:</b>
					<xsl:value-of select="concat(' ', $name)"/>
				</h5>
				<!-- Tab panes -->
				<div class="tab-content" style="border: 1px solid #dddddd; border-radius: 4px; padding: 20px">
					<div class="tab-pane active" id="tabInfo">
						<form class="form-horizontal">
							<xsl:for-each select="//DATASOURCE">
								<wf-form-row-static name="Datasource" value="{@name}" url="workflows.do#/api/{@id}/{@interface}"/>
								<wf-form-row-static name="Interface" value="{@interface}"/>
								<wf-form-row-static name="Protocol" value="{@protocol}"/>
								
								<xsl:if test=".//extraFields/field[@name = 'last_collection_date'] and .//extraFields/field[@name = 'last_collection_mdId'] and .//extraFields/field[@name = 'last_collection_total']">
									<wf-form-row-store-link name="Last collection" 
										date="{.//extraFields/field[@name = 'last_collection_date']}" 
										total="{.//extraFields/field[@name = 'last_collection_total']}" 
										url="../inspector/mdstore.do?id={.//extraFields/field[@name = 'last_collection_mdId']}" />
								</xsl:if>
							
								<xsl:if test=".//extraFields/field[@name = 'last_aggregation_date'] and .//extraFields/field[@name = 'last_aggregation_mdId'] and .//extraFields/field[@name = 'last_aggregation_total']">
									<wf-form-row-store-link name="Last aggregation" 
										date="{.//extraFields/field[@name = 'last_aggregation_date']}" 
										total="{.//extraFields/field[@name = 'last_aggregation_total']}" 
										url="../inspector/mdstore.do?id={.//extraFields/field[@name = 'last_aggregation_mdId']}" />
								</xsl:if>
								
								<xsl:if test=".//extraFields/field[@name = 'last_download_date'] and .//extraFields/field[@name = 'last_download_objId'] and .//extraFields/field[@name = 'last_download_total']">
									<wf-form-row-store-link name="Last download" 
										date="{.//extraFields/field[@name = 'last_download_date']}" 
										total="{.//extraFields/field[@name = 'last_download_total']}" 
										url="objectstoreInspector.do#/inspect.do/{.//extraFields/field[@name = 'last_download_objId']}" />
								</xsl:if>
								
								<div class="form-group">
									<div class="col-sm-offset-3 col-sm-9">
										<button class="btn btn-sm btn-primary" ng-click="editAccessParams()">access params</button>
									</div>
								</div>
	
								<hr/>
							</xsl:for-each>

							<wf-form-row-static name="Workflow" value="{$name}" value-description="{//WORKFLOW_DESCRIPTION}" url="isManager.do#/profile/{$id}"/>
							<wf-form-row-static name="Family" value="{//WORKFLOW_FAMILY}"/>
							
							<xsl:choose>
								<xsl:when test="//STATUS/LAST_EXECUTION_STATUS = 'SUCCESS'">
									<wf-form-row-label name="Last execution" value="SUCCESS" label-class="label-success"  date="{//STATUS/LAST_EXECUTION_DATE}"/>
								</xsl:when>
								<xsl:when test="//STATUS/LAST_EXECUTION_STATUS = 'FAILURE'">
									<wf-form-row-label name="Last execution" value="FAILURE" label-class="label-danger"  date="{//STATUS/LAST_EXECUTION_DATE}"/>
								</xsl:when>
								<xsl:otherwise>
								   <wf-form-row-static name="Last execution" value="not yet executed" value-style="white-space: nowrap; font-style: italic;"/>
								</xsl:otherwise>
							</xsl:choose>
							

							<xsl:if test="count(//NODE[@type='LaunchWorkflow' or @type='LaunchWorkflowTemplate']) &gt; 0">
								<hr />
								<wf-sub-workflows wf-id="{$id}" graph-id="currentGraphId" show-graph-modal="showGraphModal" />
							</xsl:if>

							<div class="form-group" style="margin-top: 50px">
								<div class="col-sm-offset-3 col-sm-9">
									<button class="btn btn-primary" ng-click="executeWf('{$id}')">
										<xsl:if test="$status != 'EXECUTABLE' or $startMode = 'DISABLED'">
											<xsl:attribute name="disabled">disabled</xsl:attribute>
										</xsl:if>
										<span style="margin-right: 8px" class="glyphicon glyphicon-play"></span>
										Launch
									</button>
									<button type="button" class="btn btn-default" ng-click="refresh()" style="margin-left: 5px;">
										<span class="glyphicon glyphicon-refresh"></span>
									</button>
									
									<button type="button" class="btn btn-default pull-right" ng-click="showGraph('{$id}')">
										<span class="glyphicon glyphicon-picture"></span> Graph
									</button>
								</div>
							</div>
						</form>

					</div>

					<div class="tab-pane" id="tabParameters">
						<xsl:choose>
							<xsl:when test="count(//CONFIGURATION/PARAMETERS/PARAM) &gt; 0">
								<form class="form-horizontal" name="wfParamatersForm">
									<xsl:for-each select="//CONFIGURATION/PARAMETERS/PARAM">
							
										<xsl:choose>
											<xsl:when test="@managedBy='system'">
												<wf-form-row-static name="{@name}" value="{.}" description="{@description}" value-style="font-family: monospace">
													<xsl:if test="@category">
														<xsl:attribute name="category">
															<xsl:value-of select="@category" />
														</xsl:attribute>
													</xsl:if>
												</wf-form-row-static>
											</xsl:when>

											<xsl:when test="@type='boolean'">
												<wf-form-row-select name="{@name}" description="{@description}"
																	mandatory="{@required}"
																	init-value="{.}"
																	ng-model="params.{@name}"
																	ng-original-model="originalParams.{@name}"
																	values="[{{'id':'true','name':'TRUE'}},{{'id':'false','name':'FALSE'}}]">
													<xsl:if test="@category">
														<xsl:attribute name="category">
															<xsl:value-of select="@category" />
														</xsl:attribute>
													</xsl:if>																	
												</wf-form-row-select>
											</xsl:when>
											<xsl:when test="@function">
												<wf-form-row-select name="{@name}" description="{@description}"
																	mandatory="{@required}"
																	init-value="{.}"
																	ng-model="params.{@name}"
																	ng-original-model="originalParams.{@name}"
																	values-function="{@function}">
													<xsl:if test="@category">
														<xsl:attribute name="category">
															<xsl:value-of select="@category" />
														</xsl:attribute>
													</xsl:if>
												</wf-form-row-select>
											</xsl:when>
											<xsl:otherwise>
												<wf-form-row-text name="{@name}" description="{@description}"
																  mandatory="{@required}"
																  init-value="{.}"
																  ng-model="params.{@name}"
																  ng-original-model="originalParams.{@name}">
													<xsl:attribute name="type">
														<xsl:choose>
															<xsl:when test="@type">
																<xsl:value-of select="@type"/>
															</xsl:when>
															<xsl:otherwise>
																string
															</xsl:otherwise>
														</xsl:choose>
													</xsl:attribute>
													<xsl:if test="@category">
														<xsl:attribute name="category">
															<xsl:value-of select="@category" />
														</xsl:attribute>
													</xsl:if>
												</wf-form-row-text>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
									<xsl:if test="count(//CONFIGURATION/PARAMETERS/PARAM[@managedBy = 'user']) &gt; 0">
										<div class="form-group">
											<div class="col-sm-offset-3 col-sm-9">
												<button class="btn btn-primary" ng-click="updateParameters('{$id}', params)"
														ng-disabled="wfParamatersForm.$invalid">
													<span class="glyphicon glyphicon-ok" style="margin-right: 8px"></span>
													Update
												</button>
												<button class="btn btn-default" style="margin-left:5px;" ng-click="resetParameters()">
													<span class="glyphicon glyphicon-remove" style="margin-right:8px"></span>
													Reset
												</button>
											</div>
										</div>
									</xsl:if>
								</form>
							</xsl:when>
							<xsl:otherwise>
								No Parameters
							</xsl:otherwise>
						</xsl:choose>
					</div>

					<div class="tab-pane" id="tabHistory">
						<wf-history ng-model="history" on-refresh="updateHistory('{$id}')"/>
					</div>

					<div class="tab-pane" id="tabSettings">
						<wf-form-update wf-id="{$id}" />
					</div>
				</div>
			</div>
		</div>
	</xsl:template>

</xsl:stylesheet>



