package eu.dnetlib.functionality.modular.ui.workflows.controllers;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.common.collect.Maps;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher.DnetParamValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DnetParamValuesController extends AbstractAjaxController {

	private static final Log log = LogFactory.getLog(DnetParamValuesController.class);
	@Autowired
	private List<ValidNodeValuesFetcher> validNodesFetchers;

	@RequestMapping("/ui/wf/obtainValidValues.do")
	public @ResponseBody List<DnetParamValue> obtainValidValues(final HttpServletRequest request,
			final HttpServletResponse response,
			@RequestParam(value = "bean", required = true) final String bean) throws IOException {

		final ValidNodeValuesFetcher fetcher = findValidNodeValuesFetcher(bean);

		if (fetcher == null) {
			log.error("ValidNodeValuesFetcher not found: " + bean);
			return new ArrayList<>();
		} else {
			final Map<String, String> params = findParams(request);
			final List<DnetParamValue> list = fetcher.apply(params);
			Collections.sort(list);

			if (params.containsKey("filter")) {
				final String filter = params.get("filter");
				return list.stream().filter(it -> it.getName().contains(filter)).collect(Collectors.toList());
			}
			return list;
		}
	}

	private ValidNodeValuesFetcher findValidNodeValuesFetcher(final String bean) {
		for (final ValidNodeValuesFetcher fetcher : this.validNodesFetchers) {
			if (fetcher.getName().equals(bean)) { return fetcher; }
		}
		return null;
	}

	private Map<String, String> findParams(final HttpServletRequest request) {
		final Map<String, String> params = Maps.newHashMap();

		final Enumeration<?> e = request.getParameterNames();
		while (e.hasMoreElements()) {
			final String name = (String) e.nextElement();
			params.put(name, request.getParameter(name));
		}
		return params;
	}

}
