var dnetWorkflowsControllers = angular.module('dnetWorkflowsControllers', ['ngGrid', 'wfProcessViewer', 'wfGraphViewer', 'wfFormFields', 'repoAccessParamsEditor']);


dnetWorkflowsControllers.controller('wfListCtrl', ['$scope', '$http', '$routeParams',
	function ($scope, $http, $routeParams) {
		$scope.currentSection = $routeParams.section.replace(/(\_|\+)/g, ' ');
		$scope.wfList = [];
		$http.get('wf/list_workflows.json?section=' + $scope.currentSection).success(function (data) {
			$scope.wfList = data;
		}).error(function (err) {
			show_notification("error", err.message);
		});
	}
]);


dnetWorkflowsControllers.controller('workflowCtrl', [
	'$scope', '$http', '$sce', '$location', '$route', '$routeParams', 
	function ($scope, $http, $sce, $location, $route, $routeParams) {
		$scope.currentWorkflowId = $routeParams.wf;

		$scope.currentProcId = '';
		$scope.showProcModal = false;
		$scope.showAccessParamsModal = false;
		
		$scope.currentGraphId = '';
		$scope.showGraphModal = false;
		
		$scope.history = [];
		$scope.params = {};
		$scope.originalParams = {};
		
		$scope.showGraph = function (wfId) {
			$scope.currentGraphId = wfId;
			$scope.showGraphModal = true;
		};
		
		$scope.executeWf = function (wfId) {
			$http.get('wf/wf.start?id=' + wfId).success(function (data) {
				$scope.currentProcId = data.procId;
				$scope.showProcModal = true;
			}).error(function (err) {
				show_notification('error', 'Error executing wf: ' + err.message);
			});
		};
		
		$scope.editAccessParams = function () {
			$scope.showAccessParamsModal = true;
		};

		$scope.refresh = function () {
			$route.reload();
		};

		$scope.updateHistory = function (wfId) {
			$http.get('wf/journal.find?wfs=' + wfId).success(function (data) {
				$scope.history = data;
			}).error(function (err) {
				show_notification('error', 'Error fetching history: ' + err.message);
			});
		};

		$scope.updateParameters = function (wfId, params) {
			showSpinner();

			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('wf/saveParams.do', $.param({
				'wf': wfId,
				'params': JSON.stringify(params)
			})).success(function (b) {
				hideSpinner();
				show_notification('info', 'Workflow updated !');
				$scope.originalParams = angular.copy($scope.params);
			}).error(function (err) {
				hideSpinner();
				show_notification('error', 'Error updating wf: ' + err.message);
			});
		}

		$scope.resetParameters = function () {
			$scope.params = angular.copy($scope.originalParams);
		}

	}
]);

dnetWorkflowsControllers.controller('repoApiCtrl', [
	'$scope', '$http', '$timeout', '$sce', '$route', '$routeParams', '$location',
	function ($scope, $http, $timeout, $sce, $route, $routeParams, $location) {
		
		initSpinner();
		
		$scope.params = {};
		$scope.originalParams = {};
		
		$scope.currentProcId = '';
		$scope.showProcModal = false;
		$scope.showAccessParamsModal = false;
		
		$scope.availableRepohiWfs = [];
		
		$scope.refresh = function () {
			$route.reload();
		};
		
		$scope.editAccessParams = function () {
			$scope.showAccessParamsModal = true;
		};
		
		$scope.updateMdIdPath = function(repoId, ifaceId) {
			elem = document.getElementById('mdIdPath');
			
			let oldValue = elem.innerHTML; 
			let newValue = prompt("Insert the XPATH that refers the record identifiers", oldValue);
			
			if (newValue != null && newValue != oldValue) {
				showSpinner();
				$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
				$http.post('repo/metadatadIdPath.update', $.param({
					'id'    : repoId,
					'iface' : ifaceId,
					'path'  : newValue
				})).success(function (data) {
					hideSpinner();
					elem.innerHTML = newValue;
				}).error(function (err) {
					show_notification('error', 'Error updating metadata_identifier_path: ' + err.message);
					hideSpinner();
				});
			}
		};
		
		$scope.updateCompatibilityLevel = function(repoId, ifaceId, level) {
			var url = '';
			if (level) { url = 'repo/repoApiCompliance.update?id=' + repoId + '&iface=' + ifaceId + '&compliance=' + level; }
			else       { url = 'repo/repoApiCompliance.reset?id=' + repoId + '&iface=' + ifaceId }
		
			showSpinner();
			$http.get(url).success(function (data) {
				hideSpinner();
				show_notification('info', 'Api correctly updated !');
				$route.reload();
			}).error(function (err) {
				hideSpinner();
				show_notification('error', 'Error updating compliance: ' + err.message);
			});
		};
		
		$scope.findRepoHiWorkflows = function(compliance, type) {
			showSpinner();
			
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('wf/repohi_wfs.find', $.param({
				'compliance' : compliance,
				'type' : type
			})).success(function (data) {
				hideSpinner();
				$scope.availableRepohiWfs = data;
			}).error(function (err) {
				show_notification('error', 'Error listing repo-hi workflows: ' + err.message);
				hideSpinner();
			});
		};
		
		$scope.newRepoWorkflow = function (repoId, ifaceId, repoHiWfId) {
			showSpinner();
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('wf/repohi.start', $.param({
				'id': repoId,
				'iface': ifaceId,
				'wf': repoHiWfId
			})).success(function (data) {
				if (data && data.length == 1) {
					$scope.currentProcId = data[0];
					$scope.showProcModal = true;
				}
			}).error(function (err) {
				hideSpinner();
				show_notification('error', 'Error starting REPO_HI workflow:' + err.message);
			});
		};
		
		$scope.destroyRepoWorkflow = function (wfId) {
			showSpinner();
			$http.post('wf/repobye.start?wf=' + wfId).success(function (data) {
				if (data && data.length == 1) {
					$scope.currentProcId = data[0];
					$scope.showProcModal = true;
				}
			}).error(function (err) {
				hideSpinner();
				show_notification('error', 'Error starting REPO_BYE workflow:' + err.message);
			});
		};
	}
]);
