package eu.dnetlib.functionality.modular.ui.users;

import javax.servlet.http.HttpServletRequest;

import com.google.common.collect.Sets;

public class MockAuthorizationManager implements AuthorizationManager {

	private String id;
	private String fullname;
	private String email;

	@Override
	public User obtainUserDetails(HttpServletRequest request) {
		final User userMock = new User();
		
		userMock.setId(id);
		userMock.setFullname(fullname);
		userMock.setPermissionLevels(Sets.newHashSet(PermissionLevel.SUPER_ADMIN));
		userMock.setEmail(email);
		return userMock;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getFullname() {
		return fullname;
	}

	public void setFullname(String fullname) {
		this.fullname = fullname;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}
}
