/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui;

import com.google.common.collect.Maps;
import eu.dnetlib.conf.PropertyFetcher;
import eu.dnetlib.conf.WebappContextPropertyLocationFactory;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ui.ModelMap;

public class ContainerPropertiesController
extends ModuleEntryPoint {
    private static final Log log = LogFactory.getLog(ContainerPropertiesController.class);
    private final ResourcePatternResolver pathResolver = new PathMatchingResourcePatternResolver();
    @Autowired
    private PropertyFetcher propertyFetcher;
    private Properties propertyFetcherProps;
    @Autowired
    private WebappContextPropertyLocationFactory propertyLocations;

    @Override
    protected void initialize(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.propertyFetcherProps = this.propertyFetcher.getProps();
        map.addAttribute("properties", this.fetchProperties());
    }

    private Map<String, List<PropertyInfo>> fetchProperties() throws IOException {
        TreeMap propertiesMap = Maps.newTreeMap();
        for (String location : this.propertyLocations.getLocations()) {
            log.debug((Object)String.format("Loading properties from %s", location));
            for (Resource propertyFile : this.pathResolver.getResources(location)) {
                Properties properties = new Properties();
                log.debug((Object)String.format("URL: %s", propertyFile.getURL()));
                properties.load(propertyFile.getInputStream());
                for (Map.Entry<Object, Object> property : properties.entrySet()) {
                    List<PropertyInfo> propertyInfoList = propertiesMap.containsKey(property.getKey()) ? (List)propertiesMap.get(property.getKey()) : new ArrayList<PropertyInfo>();
                    propertyInfoList.add(new PropertyInfo((String)property.getValue(), propertyFile.getFilename(), this.isWinning((String)property.getKey(), (String)property.getValue())));
                    propertiesMap.put((String)property.getKey(), propertyInfoList);
                }
            }
        }
        return propertiesMap;
    }

    private Boolean isWinning(String property, String value) {
        String winningPropertyValue = this.propertyFetcherProps.getProperty(property);
        return value.equals(winningPropertyValue);
    }

    private class PropertyInfo {
        String value;
        String sourcePropertyFile;
        Boolean isChecked;

        public PropertyInfo(String value, String sourcePropertyFile, Boolean isChecked) {
            this.value = value;
            this.sourcePropertyFile = sourcePropertyFile;
            this.isChecked = isChecked;
        }

        public String getValue() {
            return this.value;
        }

        public String getSourcePropertyFile() {
            return this.sourcePropertyFile;
        }

        public Boolean getIsChecked() {
            return this.isChecked;
        }
    }
}

