/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui;

import com.google.common.collect.Sets;
import eu.dnetlib.functionality.modular.ui.AbstractMenu;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.ModulesMenu;
import eu.dnetlib.functionality.modular.ui.users.AccessLimited;
import eu.dnetlib.functionality.modular.ui.users.PermissionLevel;
import eu.dnetlib.functionality.modular.ui.users.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class EntryPointsAggregator {
    @Autowired(required=false)
    private List<ModuleEntryPoint> entryPoints = new ArrayList<ModuleEntryPoint>();
    @Autowired(required=false)
    private List<AbstractMenu> otherMenus = new ArrayList<AbstractMenu>();

    public List<ModuleEntryPoint> getEntryPoints() {
        return this.entryPoints;
    }

    public void setEntryPoints(List<ModuleEntryPoint> entryPoints) {
        this.entryPoints = entryPoints;
    }

    public List<AbstractMenu> getMenus(User user) {
        HashMap<String, ModulesMenu> map = new HashMap<String, ModulesMenu>();
        for (ModuleEntryPoint entry : this.entryPoints) {
            if (!entry.isValidMenuEntry() || !this.verifyAuthorization(entry, user)) continue;
            String group = entry.getGroup();
            if (!map.containsKey(group)) {
                map.put(group, new ModulesMenu(group));
            }
            ((ModulesMenu)map.get(group)).addEntry(entry);
        }
        ArrayList<AbstractMenu> items = new ArrayList<AbstractMenu>();
        for (AbstractMenu menu : this.otherMenus) {
            if (menu instanceof AccessLimited) {
                if (!this.verifyAuthorization((AccessLimited)((Object)menu), user) || menu.getEntries().size() <= 0) continue;
                items.add(menu);
                continue;
            }
            if (menu.getEntries().size() <= 0) continue;
            items.add(menu);
        }
        for (ModulesMenu item : map.values()) {
            item.complete();
            items.add(item);
        }
        Collections.sort(items);
        return items;
    }

    private boolean verifyAuthorization(AccessLimited entry, User user) {
        if (user.getPermissionLevels().contains((Object)PermissionLevel.SUPER_ADMIN)) {
            return true;
        }
        return Sets.intersection(user.getPermissionLevels(), entry.getPermissionLevels()).size() > 0;
    }
}

