/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.lightui.objects;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.modular.ui.lightui.LightUIUtils;
import eu.dnetlib.functionality.modular.ui.lightui.clients.ISLookupLightUIClient;
import eu.dnetlib.functionality.modular.ui.lightui.clients.IndexLightUIClient;
import eu.dnetlib.functionality.modular.ui.lightui.objects.IndexConfiguration;
import eu.dnetlib.functionality.modular.ui.lightui.objects.SearchField;
import eu.dnetlib.functionality.modular.ui.lightui.objects.ValueWithLabel;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class SearchFieldGrouper {
    private static final int maxBrowseValues = 100;
    private static final Log log = LogFactory.getLog(SearchFieldGrouper.class);
    @Resource
    private IndexLightUIClient indexClient;
    @Resource
    private ISLookupLightUIClient isLookupClient;

    public List<SearchField> getAllFields(String lightuiId) {
        ArrayList res = Lists.newArrayList();
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((Reader)new StringReader(this.isLookupClient.getLightUiProfile(lightuiId)));
            Node searchNode = doc.selectSingleNode("//CONFIGURATION/SEARCH");
            IndexConfiguration idx = LightUIUtils.calculateIndexConfiguration(searchNode);
            res.addAll(this.getPredefinedFields(searchNode));
            res.addAll(this.calculateBrowseFields(idx, searchNode));
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining search fields", (Throwable)e);
        }
        return res;
    }

    private List<SearchField> calculateBrowseFields(IndexConfiguration idx, Node node) {
        try {
            return this.indexClient.browse("*=*", idx, LightUIUtils.getBrowseFields(node), 100).stream().map(r -> {
                SearchField sf = new SearchField();
                sf.setField(r.getField());
                sf.setLabel(r.getLabel());
                sf.setOperator("exact");
                sf.setPredefinedValues(r.getValues().stream().map(bv -> new ValueWithLabel(bv.getValue() + " (" + bv.getSize() + ")", bv.getValue())).collect(Collectors.toList()));
                return sf;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.warn((Object)"Error executing default browse query", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    private List<SearchField> getPredefinedFields(Node node) {
        String operator;
        String label;
        String id;
        ArrayList list = Lists.newArrayList();
        for (Object o : node.selectNodes(".//TEXT_FIELD")) {
            id = ((Element)o).valueOf("@id");
            label = ((Element)o).valueOf("@label");
            operator = ((Element)o).valueOf("@operator");
            list.add(new SearchField(id, label, operator));
        }
        for (Object o : node.selectNodes(".//SELECT_FIELD")) {
            id = ((Element)o).valueOf("@id");
            label = ((Element)o).valueOf("@label");
            operator = ((Element)o).valueOf("@operator");
            ArrayList values = Lists.newArrayList();
            for (Object v : ((Element)o).selectNodes("./VALUE")) {
                String v_id = ((Element)v).valueOf("@id");
                String v_label = ((Element)v).valueOf("@label");
                values.add(new ValueWithLabel(v_label, v_id));
            }
            list.add(new SearchField(id, label, operator, values));
        }
        return list;
    }
}

