/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.utils;

import com.google.common.base.Joiner;
import eu.dnetlib.functionality.modular.ui.utils.LogLine;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class LogUiAppender
extends AppenderSkeleton {
    public static final int MAX_LOGS_IN_QUEUE = 2000;
    private final LinkedBlockingQueue<LogLine> logQueue = new LinkedBlockingQueue(2000);
    private int count = 0;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        LinkedBlockingQueue<LogLine> linkedBlockingQueue = this.logQueue;
        synchronized (linkedBlockingQueue) {
            if (this.logQueue.remainingCapacity() == 0) {
                this.logQueue.poll();
            }
            try {
                String date = dateFormat.format(new Date(event.getTimeStamp()));
                Object[] arr = event.getThrowableStrRep();
                String strace = arr != null && arr.length > 0 ? Joiner.on((String)"\n").join(arr) : "";
                this.logQueue.put(new LogLine(this.count++, event.getLevel().toString(), event.getLoggerName(), date, event.getRenderedMessage(), strace));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogLine> tail_N(int n) throws Exception {
        if (n <= 0) {
            return new ArrayList<LogLine>();
        }
        LinkedBlockingQueue<LogLine> linkedBlockingQueue = this.logQueue;
        synchronized (linkedBlockingQueue) {
            return StreamSupport.stream(this.logQueue.spliterator(), false).skip(Math.max(0, this.logQueue.size() - n)).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogLine> tail_continue(int after) throws Exception {
        LinkedBlockingQueue<LogLine> linkedBlockingQueue = this.logQueue;
        synchronized (linkedBlockingQueue) {
            return StreamSupport.stream(this.logQueue.spliterator(), false).filter(ll -> ll.getId() > (long)after).collect(Collectors.toList());
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

