/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.objects;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.modular.ui.workflows.objects.EnvParam;
import eu.dnetlib.msro.workflows.procs.Token;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NodeTokenInfo {
    private String name;
    private long start;
    private long end;
    private List<EnvParam> params;

    public NodeTokenInfo(String name) {
        this.name = name;
        this.start = 0L;
        this.end = 0L;
        this.params = Lists.newArrayList();
    }

    public NodeTokenInfo(Token token) {
        this.start = token.getStartDate();
        this.end = token.getEndDate();
        this.name = token.getNodeName();
        this.params = Lists.newArrayList();
        for (Map.Entry e : token.getEnv().getAttributes().entrySet()) {
            this.params.add(new EnvParam((String)e.getKey(), e.getValue() != null ? e.getValue().toString() : null));
        }
        Collections.sort(this.params);
    }

    public String getName() {
        return this.name;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public List<EnvParam> getParams() {
        return this.params;
    }
}

