var wfProcessViewer = angular.module("wfProcessViewer", []);

wfProcessViewer.directive("wfProcessModal", function ($http) {
	return {
		restrict: 'E',
		transclude: true,
		replace:true,
		scope: {
	        'procId'  : '=',
	        'visible' : '='
		},
		templateUrl: '../resources/html/wf/wf-process-modal.html',
		
		link: function (scope, element, attrs, ctrl) {
			scope.currentParam = {};
			scope.current = {};
			scope.contentToShow = '';
			scope.currentNode = {};
			
			$(element).modal({'show': false});
		
			scope.$watch(function() {
				return scope.visible;
			}, function(value) {
				if (value == true && scope.procId) { 
					$(element).modal('show');
					scope.visible = false;
					scope.proc = {};
					scope.currentNode = {};
					scope.currentParam = {};
					scope.refresh();
				}
			});
			
			scope.showContent = function(c) {
				scope.contentToShow = c;
			};
			
			scope.showNodeInfo = function(node) {
				scope.currentNode = node;
			};
			
			scope.hideNodeInfo = function() {
				scope.currentNode = {};
			};
			
			scope.to_trusted = function (html_code) {
				return $sce.trustAsHtml(html_code);
			};

			scope.refresh = function () {
				showSpinner();
				$http.get('wf/journal.get?id=' + scope.procId).success(function (data) {
					scope.proc = data;
					if (data.processNodes.length > 0) {
						scope.contentToShow = 'nodes';
					} else if (data.outputParams.length > 0) {
						scope.contentToShow = 'journal';
					} else {
						scope.contentToShow = '';
					}
					hideSpinner();
				}).error(function (e) {
					show_notification('error', 'Error fetching process info: ' + e);
					hideSpinner();
				});
			}

			scope.kill = function () {
				if (confirm("Are you sure ?")) {
					showSpinner();
					$http.get('wf/proc.kill?id=' + scope.proc.procId).success(function (data) {
						scope.currentProc = {};
						hideSpinner();
						$(element).modal('hide');
						show_notification('info', 'Workflow killed !');
					}).error(function (e) {
						show_notification('error', 'Error killing process: ' + e);
						hideSpinner();
					});
				}
			}
			
			scope.calculateDateDiff = function (start, end) {
				if (start <= 0 || end <= 0) {
					return '-';
				}
				var seconds = 0;
				var minutes = 0;
				var hours = 0;
				var days = 0;
	
				if (end > start) {
					seconds = Math.round((end - start) / 1000);
	
					if (seconds > 60) {
						minutes = Math.floor(seconds / 60);
						seconds = seconds % 60;
						if (minutes > 60) {
							hours = Math.floor(minutes / 60);
							minutes = minutes % 60;
							if (hours > 24) {
								days = Math.floor(hours / 24);
								hours = hours % 24;
							}
						}
					}
				}
	
				var res = '';
				if (days > 0) {
					if (res) {
						res += ', ';
					}
					res += days + " day(s)"
				}
				if (hours > 0) {
					if (res) {
						res += ', ';
					}
					res += hours + " hour(s)"
				}
				if (minutes > 0) {
					if (res) {
						res += ', ';
					}
					res += minutes + " minute(s)"
				}
				if (seconds > 0) {
					if (res) {
						res += ', ';
					}
					res += seconds + " second(s)"
				}
	
				if (!res) {
					res = '0 seconds';
				}
	
				return res;
			}
			
			scope.setCurrentParam  = function (p) {
				scope.currentParam = p;
			}
		}
	}
});
