var module = angular.module('workflowsUI', ['ngRoute', 'ngGrid', 'wfFormFields', 'cronMaker', 'dnetWorkflowsControllers']);

module.config(['$routeProvider', function ($routeProvider) {
	$routeProvider
		.when('/list/:section', {
			controller: 'wfListCtrl',
			templateUrl: '../resources/html/wf/wf-list.html'
		})
		.when('/wf/:wf', {
			controller: 'workflowCtrl',
			templateUrl: function (params) {
				if (params.wf == '_') {
					return "../resources/html/wf/empty.html";
				} else {
					return 'wf/workflow.html?id=' + params.wf + '&dt=' + new Date().getTime();
				}
			}
		}).when('/api/:repoId/:ifaceId', {
			controller: 'repoApiCtrl',
			templateUrl: function (params) {
				return 'wf/repoApi.html?repoId=' + params.repoId + "&ifaceId=" + params.ifaceId + '&dt=' + new Date().getTime();
			}
		})
		.otherwise({redirectTo: '/'});
}]);

module.directive('wfFormUpdate', function ($http) {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/wf/wf-form-update.html',
		scope: {
			wfId: '@'
		},
		link: function (scope) {
			initSpinner();
			
			scope.showCronMakerModal = false;
			scope.wf = {};
			scope.emailMessages = [];

			showSpinner();
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('wf/obtainValidValues.do?bean=listProfiles', $.param({
				'type'  : 'EmailDSResourceType',
				'xpath' : '//EMAIL_NAME'
			})).success(function (data) {
				hideSpinner();
				scope.emailMessages = data;
			}).error(function (err) {
				show_notification("error", err.message);
				hideSpinner();
			});
			
			scope.reset = function () {
				showSpinner();
				$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
				$http.post('wf/update_workflow.get?wfId=' + scope.wfId).success(function (data) {
					hideSpinner();
					scope.wf = data;
				}).error(function (err) {
					show_notification("error", err.message);
					hideSpinner();
				})

				scope.wf = angular.copy(scope.originalWf);
			};

			scope.addNotification = function() {
				if      (!scope.wf)               { scope.wf = { 'notifications': [ {} ] } }
				else if (!scope.wf.notifications) { scope.wf.notifications =      [ {} ] }
				else                              { scope.wf.notifications.push   ( {} ) }
			};
			
			scope.dropNotification = function(pos) {
				if (scope.wf && scope.wf.notifications && pos >= 0 && pos < scope.wf.notifications.length) {
					scope.wf.notifications.splice(pos, 1);
				}
			};
			
			scope.showCronMaker = function() {
				scope.showCronMakerModal = true;
			}
			
			scope.updateWf = function () {
				showSpinner();
				$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
				$http.post('wf/update_workflow.do', $.param({
					'json': JSON.stringify(scope.wf)
				})).success(function (data) {
					hideSpinner();
					show_notification("info", 'Workflow updated !');
				}).error(function (err) {
					show_notification("error", err.message);
					hideSpinner();
				});
			};

			scope.reset();

		}
	}
});

module.directive('bsHasErrorSimple', function () {
	return {
		restrict: "A",
		link: function (scope, element, attrs, ctrl) {
			element.toggleClass('has-feedback', true);
			var input = element.find('input[ng-model], select[ng-model]');
			if (input) {
				scope.$watch(function () {
					if (input.controller('ngModel').$invalid) {
						return 0;
					} else {
						return 1;
					}
				}, function (code) {
					if (code < 0) return;
					element.toggleClass('has-error', (code == 0));
					element.toggleClass('has-success', (code == 1));
				});
			}
		}
	};
});


module.directive('wfSubWorkflows', function ($http) {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/wf/wf-sub-workflows.html',
		scope: {
			wfId: '@',
			graphId: '=',
			showGraphModal: '='
		},
		link: function (scope) {
			scope.currentProcId = '';
			scope.showProcModal = false;
			scope.subWorkflows = [];
			
			$http.get('wf/obtainSubWorkflows.do?id=' + scope.wfId).success(function (data) {
				scope.subWorkflows = data;
			}).error(function (err) {
				show_notification('error', 'error fetching sub workflows: ' + err.message);
			});
			
			scope.executeWf = function (wfId, name, parent, isTemplate, warning) {
				
				if (warning && !confirm("You are launching a part of a not well configured workflow. Are you sure ?")) {
					show_notification("info", "Execution aborted");
					return;
				}
	
				var url = '';
				if (isTemplate) {
					url = 'wf/wfTemplate.start?node=' + name + '&parentWf=' + parent;
				} else if (isTemplate) {
					url = 'wf/wf.start?id=' + wfId;
				}
				
				$http.get(url).success(function (data) {
					scope.currentProcId = data.procId;
					scope.showProcModal = true;
				}).error(function (err) {
					show_notification("error", "Error executing wf: " + err.message);
				});
			};
			
			scope.showGraph = function (wfId) {
				scope.graphId = wfId;
				scope.showGraphModal = true;
			};
		}
	}
});

module.directive('wfHistory', function () {
	return {
		restrict: 'E',
		templateUrl: '../resources/html/wf/wf-history.html',
		scope: {
			ngModel: '=',
			onRefresh: '&'
		},
		link: function (scope) {
			scope.currentId = '';
			scope.showModal = false;
			
			scope.doOnRefesh = function () {
				scope.onRefresh();
			}
			scope.showProcess = function (procId) {
				scope.currentId = procId;
				scope.showModal = true;
			}
		}
	}
});


