package eu.dnetlib.functionality.modular.ui.index;

import java.util.Map;

import com.google.common.collect.Maps;
import eu.dnetlib.clients.index.client.IndexClient;
import eu.dnetlib.clients.index.client.IndexClientException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

//@Component(value = "indexClientMap")
public class IndexClientMap {

	private static final Log log = LogFactory.getLog(IndexClientMap.class);

	private Map<String, IndexClient> map = Maps.newHashMap();

	public void shutdown() throws IndexClientException {
		log.debug("shutdown index clients");
		for (IndexClient client : map.values()) {
			client.stop();
		}
	}

	public Map<String, IndexClient> getMap() {
		return map;
	}

	public void setMap(final Map<String, IndexClient> map) {
		this.map = map;
	}

}